<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('diagnosis', function (Blueprint $table) {
            $table->comment('诊断');

            $table->bigIncrements('id');
            $table->string('name', 128)->comment('诊断');
            $table->string('content')->comment('显示内容');
            $table->string('code', 128)->comment('诊断简码');
            $table->string('encoding', 128)->comment('外部编码');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('diagnosis');
    }
};
