<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

// 不需要登录的组
// 小程序静默登录
Route::post('login', 'App\Api\Controllers\UserController@login');
// Route::get('test', 'App\Api\Controllers\DrugController@test');

# 获取药品列表
Route::get('/drugs', 'App\Api\Controllers\DrugController@drugList');
# 获取药店列表
Route::get('/pharmacys', 'App\Api\Controllers\PharmacyController@PharmacyList');
# 获取诊断列表
Route::get('/diagnosis', 'App\Api\Controllers\DiagnosisController@diagnosisList');
# 获取问诊人列表
Route::get('/patients', 'App\Api\Controllers\PatientController@patientList');
# 问诊人新增
Route::post('/patients-add', 'App\Api\Controllers\PatientController@add');
# 问诊人编辑
Route::post('/patients-update', 'App\Api\Controllers\PatientController@update');
# 问诊人删除
Route::post('/patients-delete', 'App\Api\Controllers\PatientController@delete');
# 设置默认问诊人
Route::post('/patients-setDefault', 'App\Api\Controllers\PatientController@setDefault');
# 获取默认问诊人
Route::post('/patients-getDefault', 'App\Api\Controllers\PatientController@getDefault');
# 获取问诊问题列表
Route::get('/inquirys', 'App\Api\Controllers\InquiryController@InquirytList');
# 开方
Route::post('/prescription-create', 'App\Api\Controllers\PrescriptionController@create');



// 需要验证是否登录的路由组
Route::middleware(['jwt.auth'])->group(function () {
    // 获取用户信息
    Route::get('/users', 'App\Api\Controllers\UserController@userInfo');
    
    
});