<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\DoctorModel;
use App\Models\PatientModel;
use App\Models\PharmacistModel;
use App\Models\PharmacyDrugModel;
use App\Models\PharmacyModel;
use App\Models\PrescriptionLogModel;
use App\Models\PrescriptionModel;
use App\Models\User;
use App\Services\SmsService;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

// 问诊人控制器
class PrescriptionController extends BaseApiController
{
    public function test()
    {
        // 分派医师 医师当日开方未达到上限以及是否在时间段的搜索出来
        // $site_config = DB::table('admin_settings')->where('slug', 'site_config')->value('value');
        // $site_config = json_decode($site_config, true);
        // $pharmacy = PharmacyDrugModel::where('pharmacy_id',1)->get();
        $doctors = DoctorModel::query()->where('status', 1)->get();
        $randomDoctor = $doctors->random();

        return $this->success($randomDoctor);
    }

    // 处方列表
    public function prescriptionList(Request $request)
    {
        $authInfo = auth('api')->user();
        $query = PrescriptionModel::query();
        // TODO 判断当前登录的用户角色
        // $userInfo = User::with(['doctor', 'pharmacist'])->find($authInfo->id);
        if ($authInfo->last_login_type == User::LOGIN_TYPE_USER) {
            $query->where('user_id', $authInfo->id);
        } elseif ($authInfo->last_login_type == User::LOGIN_TYPE_DOCTOR) { // 医师
            $doctor = DoctorModel::query()->where('user_id', $authInfo->id)->first();
            $query->where('doctor_id', $doctor->id);
        } elseif ($authInfo->last_login_type == User::LOGIN_TYPE_PHARMACY) { // 药店
            $pharmacy = PharmacyModel::query()->where('user_id', $authInfo->id)->first();
            $query->where('pharmacy_id', $pharmacy->id);
        }

        // 时间段
        $start_time = $request->input('start_time');
        $end_time = $request->input('end_time');
        if ($start_time && $end_time) {
            $query->whereBetween('created_at', [$start_time, $end_time]);
        } elseif ($start_time) {
            $query->where('created_at', '>=', $start_time);
        } elseif ($end_time) {
            $query->where('created_at', '<=', $end_time);
        }

        // 状态
        $status = $request->input('status');
        if ($status) {
            $query->where('status', $status);
        }

        // 分页
        $page = $request->input('page', 1);
        $perPage = $request->input('per_page', 10);
        $prescription = $query->orderBy('id', 'desc')->paginate($perPage, ['*'], 'page', $page);

        // $prescription = $query->paginate(10);
        return $this->success($prescription);
    }

    // 处方详情
    public function prescriptionDetail(Request $request)
    {
        $prescription_id = $request->input('prescription_id');
        $prescription = PrescriptionModel::query()->where('id', $prescription_id)->first();

        return $this->success($prescription);
    }

    // 开方
    public function create(Request $request)
    {
        $authInfo = auth('api')->user();
        $pharmacy_id = 0;
        $pharmacy = null;
        // 获取当前用户信息,如果是药店则无需传pharmacy_id参数
        if ($authInfo->last_login_type == User::LOGIN_TYPE_PHARMACY) {
            $pharmacy = PharmacyModel::query()->where('user_id', $pharmacy_id)->first();
            $pharmacy_id = $pharmacy->id;
        } elseif ($authInfo->last_login_type == User::LOGIN_TYPE_DOCTOR) {
            $pharmacy_id = $request->input('pharmacy_id');
            $pharmacy = PharmacyModel::query()->where('id', $pharmacy_id)->first();
            if (! $pharmacy) {
                return $this->failed('药店信息不存在');
            }
        } else {
            return $this->failed('pharmacy_id不能为空');
        }
        // 生成处方单号
        $patient_id = $request->input('patient_id');
        // 获取问诊人信息
        $patient = PatientModel::query()->where('id', $patient_id)->first();
        $patient_age = getAgeByIdCard($patient->id_card);
        $prescription = new PrescriptionModel;
        $prescription->status = PrescriptionModel::PRESCRIPTION_STATUS_PENDING;
        $prescription->user_id = $authInfo->id; // 获取当前用户ID
        // 问诊人信息
        $prescription->patient_id = $patient_id; // 问诊人编号
        $prescription->patient_name = $patient->name; // 问诊人姓名
        $prescription->patient_age = $patient_age; // 问诊人年龄
        $prescription->patient_gender = $patient->gender; // 问诊人性别
        // 诊断信息
        $prescription->diagnosis_id = $request->input('diagnosis_id');
        $prescription->diagnosis_name = $request->input('diagnosis_name');
        // 问诊问题
        $prescription->inquiry_info = ''; // TODO 问诊问题
        // 用药信息
        $prescription->drug_info = ''; // TODO 用药信息
        // 分派医师 TODO 医师当日开方未达到上限以及是否在时间段的搜索出来
        // 判断是否开启时间段
        // foreach ($doctors as $key => $doctor) {
        // }
        $doctors = DoctorModel::query()->where('status', 1)->get();
        $randomDoctor = $doctors->random();
        $prescription->doctor_id = $randomDoctor->id;
        $prescription->doctor_name = $randomDoctor->mame;
        $prescription->doctor_online_hospital_name = $randomDoctor->online_hospital_name;
        $prescription->doctor_department = $randomDoctor->department;
        $prescription->doctor_title = $randomDoctor->doctor_title;
        $prescription->doctor_license_no = $randomDoctor->license_no;
        $prescription->doctor_signed_pic = $randomDoctor->signed_pic;

        // 药店信息
        $prescription->pharmacy_id = $pharmacy->id;
        $prescription->pharmacy_name = $pharmacy->name;

        // 分派药师,先搜索是否存在默认药师，如果不存在则随机抽取一个
        $pharmacist = PharmacistModel::query()->where('status', 1)->where('is_default', 1)->where('pharmacy_id', $pharmacy_id)->first();
        if (! $pharmacist) {
            $pharmacists = PharmacistModel::query()->where('status', 1)->where('pharmacy_id', $pharmacy_id)->get();
            $pharmacist = $pharmacists->random();
        }
        $prescription->pharmacist_id = $pharmacist->id;
        $prescription->pharmacist_name = $pharmacist->name;
        $prescription->pharmacist_license_number = $pharmacist->license_number;
        $prescription->pharmacist_signed_pic = $pharmacist->signed_pic;

        // 处方单 默认状态
        $prescription->status = PrescriptionModel::PRESCRIPTION_STATUS_PENDING;
        // 生成处方单信息
        $prescription_number = 0;
        if ($prescription->save()) {
            $prescription_number = $prescription->id;
        } else {
            return $this->failed('生成处方单失败');
        }

        $site_config = DB::table('admin_settings')->where('slug', 'site_config')->value('value');
        $site_config = json_decode($site_config, true);
        $prescription_limit = $site_config['prescription_limit'];

        // 判断是否为医师自动开方
        $prescription_auto = $site_config['prescription_auto'];
        if ($prescription_auto == 1) {
            $prescription->status = PrescriptionModel::PRESCRIPTION_STATUS_REVIEWING;
            $prescription->save();
        }
        // 生成医师开方日志
        $doctorLog = new PrescriptionLogModel;
        $doctorLog->pharmacy_id = $pharmacy_id;
        $doctorLog->pharmacy_name = $pharmacy->name;
        $currentTime = Carbon::now()->toDateTimeString();
        $doctorLog->log_info = $randomDoctor->mame.'在'.$currentTime.'为'.$patient->name.'（'.$patient->mobile.'）开具处方单（处方单编号：'.$prescription_number.'）';
        $doctorLog->save();

        //  TODO 判断是否药师自动审方

        // 生成药师审方日志
        $pharmacistLog = new PrescriptionLogModel;
        $pharmacistLog->pharmacy_id = $pharmacy_id;
        $pharmacistLog->pharmacy_name = $pharmacy->name;
        $currentTime = Carbon::now()->toDateTimeString();
        $pharmacistLog->log_info = $pharmacist->name.'在'.$currentTime.'为'.$patient->name.'（'.$patient->mobile.'）审方(处方单编号：'.$prescription_number.')';
        $pharmacistLog->save();
        // TODO 给医师发送短信
        $mobile = '18321861540';
        $templateName = 'verification_code';
        $templateData = ['code' => '1234'];
        $smsService = new SmsService();
        $response = $smsService->sendSms($mobile, $templateName, $templateData);
        // TODO 给药师发送短信

        return $this->success('ok');

    }

    // 开方通过
    public function pass(Request $request)
    {
        $prescription_id = $request->input('prescription_id');
        $res = PrescriptionModel::query()->where('id', $prescription_id)->update(['status' => PrescriptionModel::PRESCRIPTION_STATUS_REVIEWING]);

        return $this->success($res);
    }

    // 审方通过
    public function reviewPass(Request $request)
    {
        $prescription_id = $request->input('prescription_id');
        $res = PrescriptionModel::query()->where('id', $prescription_id)->update(['status' => PrescriptionModel::PRESCRIPTION_STATUS_SUCCESS]);

        return $this->success($res);
    }
}
