<?php
/**
 * Created by PhpStorm.
 * User: Xiao Mo
 * Date: 2020/4/23
 * Time: 11:49 上午
 */

namespace App\Common;

use Dcat\Admin\Widgets\Alert;

class Util
{
    /**
     * 获取图片完整的URL地址
     *
     * @param  string|null  $imgUrl  图片URL或者URI
     */
    public static function getImgUrl($imgUrl): string
    {
        if (! $imgUrl) {
            return '';
        }

        if (strpos($imgUrl, 'http') === false) {
            $preUrl = substr($imgUrl, 0, 2) == '//' ? 'https:' : ComConst::IMG_URL.'/';
            $imgUrl = $preUrl.$imgUrl;
        }

        return $imgUrl;
    }

    /**
     * 给URL添加https头
     *
     * @return string
     */
    public static function appendHttps(string $url)
    {
        if ($url && substr($url, 0, 2) == '//') {
            $url = 'https:'.$url;
        }

        return $url;
    }

    /**
     * 格式化价格 (分->元)
     *
     * @return string
     */
    public static function formatPrice($price)
    {
        return $price ? number_format($price / 100, 2, '.', '') : '';
    }

    /**
     * 获取数组里面指定 key 的子数组（主要用于数据库操作）
     *
     * @return array
     */
    public static function getArrayKV(array $arr, array $keys)
    {
        $kv = [];
        foreach ($keys as $k) {
            $kv[$k] = $arr[$k] ?? '';
        }

        return $kv;
    }

    /**
     * 把数组转化成json字符串
     *
     * @param  array|object  $data
     */
    public static function array2json($data): string
    {
        return json_encode($data, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
    }

    /**
     * 获取URL本地图片文件
     *
     * @return string 如：/data/abc/local_img.jpg
     */
    public static function getLocalImageFile(string $imageUrl): string
    {
        //如果图片没有域名则添加域名
        $imageUrl = self::getImgUrl($imageUrl);
        if (! $imageUrl) {
            return '';
        }

        //把图片下载到本地
        $fileExt = strrchr(strstr($imageUrl, '?', true), '.') ?: '.jpg';
        $fileName = date('YmdHis').mt_rand(1100, 9900).$fileExt;
        $tempFile = storage_path('uploads/')."/img_{$fileName}";
        $fileCont = file_get_contents($imageUrl);
        if (! $fileCont) {
            Log::error('【下载图片错误】获取图片内容失败', [
                'imgFile' => $imageUrl,
                'tempFile' => $tempFile,
            ]);

            return '';
        }
        $isSave = file_put_contents($tempFile, $fileCont);
        if (! $isSave) {
            Log::error('【下载图片错误】保存图片内容到本地失败', [
                'imgFile' => $imageUrl,
                'tempFile' => $tempFile,
            ]);

            return '';
        }
        if (! is_file($tempFile)) {
            Log::error('【下载图片错误】临时本地图片不存在', [
                'imgFile' => $imageUrl,
                'tempFile' => $tempFile,
            ]);

            return '';
        }

        return $tempFile;
    }

    /**
     * 删除本地文件
     */
    public static function deleteFile(string $filePath, ...$moreFile)
    {
        //array_unshift($moreFile, $filePath);
        $moreFile[] = $filePath;
        foreach ($moreFile as $file) {
            if (is_file($file)) {
                unlink($file);
            }
        }
    }

    /**
     * 返回不支持操作的错误信息 warning.
     */
    public static function noAuth(): Alert
    {
        $alert = Alert::make('此功能不允许通过此操作实现。', '未提供的操作');
        $alert->warning();
        $alert->icon('feather icon-alert-triangle');

        return $alert;
    }
}
