<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\PrescriptionRepository;
use App\Models\DiagnosiModel;
use App\Models\DoctorModel;
use App\Models\InquiryModel;
use App\Models\PatientModel;
use App\Models\PharmacyDrugModel;
use App\Models\PharmacyModel;
use App\Models\PrescriptionModel;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

// 处方列表
class PrescriptionController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new PrescriptionRepository(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');

            $grid->column('id', '处方单编号')->sortable();
            $grid->column('status');
            $grid->column('patient_name');
            $grid->column('patient_age');
            $grid->column('patient_gender');
            $grid->column('diagnosis_name');
            $grid->column('doctor_name');
            $grid->column('pharmacist_name');
            $grid->column('drug_info');
            $grid->column('pharmacy_name');
            // $grid->column('diagnosis_id');
            // $grid->column('inquiry_info');
            // $grid->column('doctor_id');
            // $grid->column('doctor_online_hospital_name');
            // $grid->column('doctor_department');
            // $grid->column('doctor_title');
            // $grid->column('doctor_license_no');
            // $grid->column('pharmacy_id');
            // $grid->column('pharmacist_id');
            // $grid->column('pharmacist_license_number');
            $grid->column('created_at');
            // $grid->column('updated_at')->sortable();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('patient_name')->width(3);
                $filter->like('diagnosis_name')->width(3);
                $filter->like('pharmacy_name')->width(3);
            });

            // 行按钮控制
            // $grid->disableCreateButton(); // 禁用创建按钮
            $grid->disableDeleteButton(); // 禁用删除按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new PrescriptionRepository(), function (Show $show) {
            $show->field('id')->width(4);
            $show->field('status')->width(4);
            $show->field('patient_name')->width(4);
            $show->field('patient_age')->width(4);
            $show->field('patient_gender')->width(4);
            $show->field('diagnosis_id')->width(4);
            $show->field('diagnosis_name')->width(4);
            $show->field('inquiry_info')->width(4);
            $show->field('drug_info')->width(4);
            $show->field('doctor_id')->width(4);
            $show->field('doctor_name')->width(4);
            $show->field('doctor_online_hospital_name')->width(4);
            $show->field('doctor_department')->width(4);
            $show->field('doctor_title')->width(4);
            $show->field('doctor_license_no')->width(4);
            $show->field('pharmacy_id')->width(4);
            $show->field('pharmacy_name')->width(4);
            $show->field('pharmacist_id')->width(4);
            $show->field('pharmacist_name')->width(4);
            $show->field('pharmacist_license_number')->width(4);
            $show->field('created_at')->width(4);
            $show->field('updated_at')->width(4);

            $show->panel()->tools(function ($tools) {
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new PrescriptionRepository(), function (Form $form) {
            $form->display('id')->width(4);
            $form->radio('status')->options(PrescriptionModel::PRESCRIPTION_STATUS_MAP);
            $form->select('patient_id')->options(PatientModel::all()->pluck('name', 'id'))->width(4);
            $form->select('diagnosis_id')->options(DiagnosiModel::all()->pluck('name', 'id'))->width(4);
            $form->select('doctor_id')->options(DoctorModel::all()->pluck('name', 'id'))->width(4);
            $form->select('pharmacy_id')->options(PharmacyModel::all()->pluck('name', 'id'))->width(4);
            $form->select('pharmacist_id')->options(DoctorModel::all()->pluck('name', 'id'))->width(4);
            $form->multipleSelect('inquiry_info')->options(InquiryModel::all()->pluck('question', 'id'))->width(4)->saving(function ($v) {
                return json_encode($v);
            });
            $form->multipleSelect('drug_info')->options(PharmacyDrugModel::with('drug')->get()->pluck('drug')->pluck('name', 'id'))->width(4)->saving(function ($v) {
                return json_encode($v);
            });
            $form->switch('is_voided')->width(4);

            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
        });
    }
}
