<?php

use Dcat\Admin\Admin;
use Illuminate\Routing\Router;
use Illuminate\Support\Facades\Route;

Admin::routes();

Route::group([
    'prefix' => config('admin.route.prefix'),
    'namespace' => config('admin.route.namespace'),
    'middleware' => config('admin.route.middleware'),
], function (Router $router) {
    $router->resource('auth/users', 'AdminUserController');
    $router->get('/', 'HomeController@index');

    /** 平台菜单-start **/
    // 药品
    $router->resource('drug', 'DrugController');
    // 诊断
    $router->resource('diagnosi', 'DiagnosiController');
    // 问诊人
    $router->resource('patient', 'PatientController');
    // 问诊问题
    $router->resource('inquiry', 'InquiryController');
    // 医师
    $router->resource('doctor', 'DoctorController');
    // 药店
    $router->resource('pharmacy', 'PharmacyController');
    // 药师
    $router->resource('pharmacist', 'PharmacistController');
    // 标签
    $router->resource('tag', 'TagController');
    //医师纠错
    $router->resource('doctor-correction', 'DoctorCorrectionController');
    //药店纠错
    $router->resource('pharmacy-correction', 'PharmacyCorrectionController');
    // 设置
    $router->resource('site-config', 'SiteConfigController');
    // 导入日志
    $router->resource('/import-log', 'Common\ImportLogController')->names('import-log');
    /** 平台菜单-end **/

    /** 药店菜单-start **/
    // 用法用量
    $router->resource('dosage', 'DosageController');
    /** 药店菜单-end **/
});
