<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\DoctorCorrection;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

class DoctorCorrectionController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new DoctorCorrection(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');

            $grid->column('id')->sortable();
            $grid->column('doctor_id');
            $grid->column('doctor_name');
            $grid->column('is_handle');
            $grid->column('content');
            $grid->column('created_at');
            $grid->column('updated_at')->sortable();

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框
                $filter->like('doctor_name')->width(3);

            });

            // 行按钮控制
            $grid->disableDeleteButton(); // 禁用删除按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new DoctorCorrection(), function (Show $show) {
            $show->field('id');
            $show->field('doctor_id');
            $show->field('doctor_name');
            $show->field('is_handle');
            $show->field('content');
            $show->field('created_at');
            $show->field('updated_at');

            $show->panel()->tools(function ($tools) {
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new DoctorCorrection(), function (Form $form) {
            $form->display('id');
            $form->text('doctor_id');
            $form->text('doctor_name');
            $form->text('is_handle');
            $form->text('content');

            $form->display('created_at');
            $form->display('updated_at');

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
        });
    }
}
