<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class PharmacistModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'pharmacist';

    // 是否默认[0=否,1=是]
    const IS_DEFAULT_FALSE = 0;

    const IS_DEFAULT_TRUE = 1;

    // 是否默认-文字映射
    const IS_DEFAULT_MAP = [
        self::IS_DEFAULT_FALSE => '否',
        self::IS_DEFAULT_TRUE => '是',
    ];

    // 是否默认-颜色映射
    const IS_DEFAULT_MAP_COLOR = [
        self::IS_DEFAULT_FALSE => 'gray',
        self::IS_DEFAULT_TRUE => 'success',
    ];
    // 是否启用[0=否,1=是]
    const IS_STATUS_FALSE = 0;
    const IS_STATUS_TRUE = 1;
    const IS_STATUS_MAP = [
        self::IS_STATUS_FALSE => '否',
        self::IS_STATUS_TRUE => '是',
    ];
    // 药师关联的药店,多对一
    public function pharmacy()
    {
        return $this->belongsTo(PharmacyModel::class, 'pharmacy_id', 'id');
    }

    public function getPracticingLicenseAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPhysicianLicenseAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getSignedPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }
}
