<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pharmacy_correction', function (Blueprint $table) {
            $table->comment('药店纠错');
            $table->bigIncrements('id');
            $table->integer('pharmacy_id')->comment('药店编号');
            $table->string('pharmacy_name')->default('')->comment('药店名称');
            $table->tinyInteger('is_handle')->comment('是否处理');
            $table->string('content')->default('')->comment('纠错内容');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pharmacy_correction');
    }
};
