<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Exceptions\TokenExpiredException;
use Tymon\JWTAuth\Exceptions\TokenInvalidException;
use Tymon\JWTAuth\Facades\JWTAuth;

class CustomJwtMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        try {
            // 检查 JWT Token 是否存在
            $token = $request->bearerToken();
            if (! $token) {
                return response()->json(['status' => false, 'code' => 600, 'message' => '未提供 Token', 'data' => []]);
            }

            // 尝试解析 Token
            $user = JWTAuth::parseToken()->authenticate();

            if (! $user) {
                return response()->json(['status' => false, 'code' => 600, 'message' => '用户未找到', 'data' => []]);
            }
            // 如果需要，可以在这里添加更多逻辑，例如检查用户状态等
        } catch (TokenExpiredException $e) {
            // Token 过期
            return response()->json(['status' => false, 'code' => 600, 'message' => 'Token 已过期', 'data' => []]);
        } catch (TokenInvalidException $e) {
            // Token 无效
            return response()->json(['status' => false, 'code' => 600, 'message' => '无效的 Token', 'data' => []]);
        } catch (JWTException $e) {
            // 其他 JWT 相关错误
            return response()->json(['status' => false, 'code' => 600, 'message' => '未提供 Token 或 Token 无效', 'data' => []]);
        }

        return $next($request);
    }
}
