<?php

namespace App\Admin\Extensions\ToolBar\Actions;

use App\Admin\Extensions\ToolBar\Forms\ExternalPrescriptionImportForm;
use Dcat\Admin\Grid\Tools\AbstractTool;
use Dcat\Admin\Widgets\Modal;

class ExternalPrescriptionImportAction extends AbstractTool
{
    public $title = '导入580处方单';

    public function html(): Modal
    {
        return Modal::make()
            ->lg()
            ->title($this->title)
            ->body(new ExternalPrescriptionImportForm())
            ->button("<button class='btn btn-success'><i class='feather icon-upload'></i>&nbsp;{$this->title}</button>");
    }
}
