<?php

namespace App\Admin\Controllers;

use App\Models\ExternalPrescriptionModel;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Show;

class PharmacyExternalPrescriptionController extends AdminController
{
    public function index(Content $content)
    {
        return $content
            ->header('580处方') // 设置 content-header 的标题
            ->description('列表') // 可选，设置 content-header 的副标题
            ->body($this->grid());               // 设置页面主体为 Grid
    }

    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new ExternalPrescriptionModel(), function (Grid $grid) {
            if (! Admin::user()->pharmacy_id) {
                admin_exit(Content::make()->withError(trans('admin.deny')));
            }

            $grid->model()->orderBy('id', 'DESC');
            $grid->model()->where('pharmacy_id', Admin::user()->pharmacy_id);
            $grid->column('id')->sortable();
            $grid->column('external_prescription_id', '580处方单编号');
            $grid->column('issue_at', '处方开具时间')->sortable();
            $grid->column('status', '状态');
            $grid->column('company_name', '企业名称');
            $grid->column('pharmacy_name', '药店名称');
            // $grid->column('pharmacy_id');
            $grid->column('agent', '会员/代理人');
            $grid->column('patient_name', '就诊人姓名');
            $grid->column('patient_mobile', '就诊人手机号');
            $grid->column('patient_gender', '就诊人性别')->using(ExternalPrescriptionModel::SEX_MAP);
            $grid->column('patient_age', '就诊人年龄');
            $grid->column('patient_id_card', '就诊人身份证号');
            $grid->column('doctor_name', '接诊医师姓名');
            $grid->column('diagnosis', '诊断');
            $grid->column('drug_info', '用药信息')->display(function ($drugInfoJson) {
                // 尝试将 $drugInfoJson 解码为数组
                $drugInfoArray = json_decode($drugInfoJson, true);
                // 检查解码是否成功且 $drugInfoArray 是一个数组
                if (is_array($drugInfoArray)) {
                    // 使用 array_map 来格式化每个药物的信息
                    $formattedDrugs = array_map(function ($item) {
                        return $item['drug_name'].' : '.($item['drug_spec'] ?? '').' : '.$item['drug_num'];
                    }, $drugInfoArray);

                    // 将数组转换为以逗号分隔的字符串（或根据您的需求进行其他格式化）
                    return implode(', ', $formattedDrugs);
                } else {
                    // 如果解码失败或 $drugInfoJson 不是一个有效的 JSON 字符串，返回原始值或错误消息
                    return $drugInfoJson; // 或者返回一个错误消息，如 'Invalid JSON'
                }
            })->label(); // 设置列的标签
            $grid->column('pharmacist_name', '审核药师');
            $grid->column('review_at', '审核时间');
            $grid->column('pharmacist_attr', '药师属性');
            $grid->column('dispatcher', '调配人');
            $grid->column('checker', '核对人');
            $grid->column('dispenser', '发药人');
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();
            // 工具栏普通按钮
            // $grid->tools(function ($tools) {
            //     $tools->append(new ExternalPrescriptionImportAction()); // 导入药品信息
            // });

            $grid->filter(function (Grid\Filter $filter) {
                //$filter->equal('id');
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框
                $filter->equal('external_prescription_id', '580处方单编号')->width(3);
                // $filter->equal('pharmacy_id')->select(PharmacyModel::all()->pluck('name', 'id'))->width(3);
                // $filter->equal('pharmacy_id','药店编号')->width(3);
                $filter->like('patient_name', '就诊人姓名')->width(3);
                $filter->like('patient_mobile', '就诊人手机号')->width(3);
                $filter->like('doctor_name', '接诊医生')->width(3);

            });

            // 行按钮控制
            $grid->disableCreateButton(); // 禁用创建按钮
            $grid->disableDeleteButton(); // 禁用删除按钮
            $grid->disableEditButton(); // 禁用编辑按钮

        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        // return Content::make()->title('详情')->description('详情')->body($this->showDetail($id));
        return Show::make($id, new ExternalPrescriptionModel(), function (Show $show) {
            $show->field('id');
            $show->field('external_prescription_id', '580处方单编号');
            $show->field('issue_at', '处方开具时间');
            $show->field('status', '状态');
            $show->field('company_name', '企业名称');
            $show->field('pharmacy_name', '药店名称');
            //$show->field('pharmacy_id');
            $show->field('agent', '会员/代理人');
            $show->field('patient_name', '就诊人姓名');
            $show->field('patient_mobile', '就诊人手机号');
            $show->field('patient_gender', '就诊人性别')->using(ExternalPrescriptionModel::SEX_MAP)->width(3);
            $show->field('patient_age', '就诊人年龄');
            $show->field('patient_id_card', '就诊人身份证号');
            $show->field('doctor_name', '接诊医师姓名');
            $show->field('diagnosis', '诊断');
            $show->field('drug_info', '用药信息')->as(function ($drugInfoJson) {
                // 尝试将 $drugInfoJson 解码为数组
                $drugInfoArray = json_decode($drugInfoJson, true);
                // 检查解码是否成功且 $drugInfoArray 是一个数组
                if (is_array($drugInfoArray)) {
                    // 使用 array_map 来格式化每个药物的信息
                    $formattedDrugs = array_map(function ($item) {
                        return $item['drug_name'].' : '.($item['drug_spec'] ?? '').' : '.$item['drug_num'];
                    }, $drugInfoArray);

                    // 将数组转换为以逗号分隔的字符串（或根据您的需求进行其他格式化）
                    return implode(', ', $formattedDrugs);
                } else {
                    // 如果解码失败或 $drugInfoJson 不是一个有效的 JSON 字符串，返回原始值或错误消息
                    return $drugInfoJson; // 或者返回一个错误消息，如 'Invalid JSON'
                }
            })->label(); // 设置列的标签
            $show->field('pharmacist_name', '审核药师');
            $show->field('review_at', '审核时间');
            $show->field('pharmacist_attr', '药师属性');
            $show->field('dispatcher', '调配人');
            $show->field('checker', '核对人');
            $show->field('dispenser', '发药人');
            // $show->field('created_at');
            // $show->field('updated_at');
            $show->panel()->tools(function ($tools) {
                $tools->disableEdit();
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    protected function showDetail($id) {}

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new ExternalPrescriptionModel(), function (Form $form) {
            $form->display('id');
            $form->text('external_prescription_id');
            $form->text('issue_at');
            $form->text('status');
            $form->text('company_name');
            $form->text('pharmacy_name');
            $form->text('pharmacy_id');
            $form->text('agent');
            $form->text('patient_name');
            $form->text('patient_mobile');
            $form->text('patient_gender');
            $form->text('patient_age');
            $form->text('patient_id_card');
            $form->text('doctor_name');
            $form->text('diagnosis');
            $form->text('drug_info');
            $form->text('pharmacist_name');
            $form->text('review_at');
            $form->text('pharmacist_attr');
            $form->text('dispatcher');
            $form->text('checker');
            $form->text('dispenser');

            $form->display('created_at');
            $form->display('updated_at');
        });
    }
}
