<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\DrugModel;
use App\Models\PharmacyDrugModel;
use App\Models\PharmacyModel;
use App\Models\PrescriptionModel;
use App\Models\User;
use App\Services\SmsService;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Log;

// 药品控制器
class DrugController extends BaseApiController
{
    public function test()
    {

        // $id_card = '342224198909070018';
        // if (! validateIdCard($id_card)) {
        //     return $this->failed('身份证格式错误');
        // }
        // $drug = DrugModel::query()->find(1);
        // $drug->limit_buy_7 = 4;
        // $drug->save();
        // $drug->limit_buy_7 = 5;
        // $drug->save();
        // $mobile = '18321861540';
        // $templateName = 'verification_code';
        // $templateData = ['code' => '1234'];
        // $smsService = new SmsService();
        // $response = $smsService->sendSms($mobile, $templateName, $templateData);

        // return response()->json($response);

        // return $this->success('ok');

        $search_input = '测试';
        $data = PharmacyDrugModel::where('pharmacy_id', 1)
            ->whereHas('drug', function ($query) use ($search_input) {
                $query->where('name', 'LIKE', "%{$search_input}%")
                    ->orWhere('code', 'LIKE', "%{$search_input}%"); // 这里的'%筛选条件%'是你想要匹配的药品名称
            })
            ->paginate(10);

        $data->map(function ($row) {
            return $row->drug;
        });

        return $this->success($data);
    }

    // 药品列表
    public function drugList(Request $request)
    {
        $authInfo = auth('api')->user();
        $pharmacy_id = 0;
        if ($authInfo->last_login_type == User::LOGIN_TYPE_USER) {
            $pharmacy_id = $request->input('pharmacy_id');
        } elseif ($authInfo->last_login_type == User::LOGIN_TYPE_PHARMACY) {
            $pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
            $pharmacy_id = $pharmacy->id;
        }
        $search_input = $request->input('search_input');
        // $data = PharmacyDrugModel::where('pharmacy_id', $pharmacy_id)
        //     ->whereNotNull('dosage_id')
        //     ->whereHas('drug', function ($query) use ($search_input) {
        //         $query->where('is_rx', 1);
        //         if ($search_input) {
        //             $query->where('name', 'LIKE', "%{$search_input}%")
        //                 ->orWhere('code', 'LIKE', "%{$search_input}%"); // 这里的'%筛选条件%'是你想要匹配的药品名称
        //         }
        //     })
        //     ->paginate(10);
        $data = PharmacyDrugModel::where('pharmacy_id', $pharmacy_id)
            // ->whereNotNull('dosage_id')
            ->whereHas('drug', function ($query) use ($search_input) {
                //$query->where('is_rx', DrugModel::RX_TRUE)
                $query->where(function ($subQuery) use ($search_input) {
                    if ($search_input) {
                        $subQuery->where('name', 'LIKE', "%{$search_input}%")
                            ->orWhere('code', 'LIKE', "%{$search_input}%");
                    }
                });
            })
            ->paginate(10);
        // Log::info('drug list sql=>'.$data->toSql());
        $data->map(function ($row) {
            return $row->drug;
        });

        return $this->success($data);
    }

    // 药品7日内限购
    public function drugLimit(Request $request)
    {
        $drugs = $request->input('drugs'); // [{'drug_id'=>1,'num'=>1},{'drug_id'=>2,'num'=>4}]
        $patient_id = $request->input('patient_id');
        $pharmacy_id = $request->input('pharmacy_id');

        // 当前药品未设置则使用全局的1日内限购
        $site_config = admin_setting('site_config');
        $site_config = json_decode($site_config, true);
        $limit_num = intval($site_config['prescription_limit_buy_7']);
        // 如果药品在这个黑名单中，则要判断7天最多买四盒
        $limit_keywords = explode(',', $site_config['limit_keywords']); // 麻黄素 黑名单

        // 查询已经开过方的药方(1天内)
        $oneDayAgo = Carbon::now()->subDay();
        $prescriptions = PrescriptionModel::where('patient_id', $patient_id)
            ->where('is_voided', PrescriptionModel::IS_VOIDED_FALSE) // 未作废的处方
            ->where('status', PrescriptionModel::PRESCRIPTION_STATUS_SUCCESS)
            // ->where('pharmacy_id', $pharmacy_id)
            ->where('created_at', '>=', $oneDayAgo)
            ->get();
        $drugCounts = [];
        // 判断搜索出来的处方不为空
        foreach ($prescriptions as $prescription) {
            $drugInfos = $prescription->drug_info ?? [];
            foreach ($drugInfos as $drugInfo) {
                $drugId = $drugInfo['drug_id'];
                $drugCounts[$drugId] = ($drugCounts[$drugId] ?? 0) + $drugInfo['num'];
            }
        }
        // 查询已经开过方的药方(7天内)
        $sevenDayAgo = Carbon::now()->subDay(7);
        $prescriptions_7 = PrescriptionModel::where('patient_id', $patient_id)
            ->where('is_voided', PrescriptionModel::IS_VOIDED_FALSE) // 未作废的处方
            ->where('status', PrescriptionModel::PRESCRIPTION_STATUS_SUCCESS)
            // ->where('pharmacy_id', $pharmacy_id)
            ->where('created_at', '>=', $sevenDayAgo)
            ->get();
        // 计算累计麻黄素药品购买数量
        $buyed_mahuang_counts = 0;
        foreach ($prescriptions_7 as $prescription_7) {
            $drugInfos_7 = $prescription_7->drug_info ?? [];
            foreach ($drugInfos_7 as $drugInfo_7) {
                if ($drugInfo_7 && in_array($drugInfo_7->drug_name, $limit_keywords)) {
                    $buyed_mahuang_counts += $drugInfo_7['num'];
                }
            }
        }
        // 处理麻黄素药品数据
        $mahuangsu_num = 0; // 麻黄素药品数量
        foreach ($drugs as &$drug) {
            $drugModel = DrugModel::find($drug['drug_id']);
            if (! $drugModel) {
                $errMsg = '药品不存在';

                return $this->failed($errMsg, ['add_status' => false]);
            }
            $drug['mahuangsu_status'] = 0; // 0：不是麻黄素药品
            $drug['limit_num'] = $limit_num; // 赋值全局限购数量
            if ($drugModel->limit_buy_7 > 0) {
                $drug['limit_num'] = $drugModel->limit_buy_7;
            }
            $buyedCount = $drugCounts[$drug_id] ?? 0; // 历史已购买数量
            $canBuyCount = $drug['limit_num'] - $buyedCount; // 普通药品剩余可购买数量
            if ($canBuyCount <= 0) {
                $errMsg = '药品['.$drugModel->name.']剩余购买数量不足~';

                return $this->failed($errMsg, ['add_status' => false]);
            }
            if ($drugModel && in_array($drugModel->name, $limit_keywords)) {
                $mahuangsu_num += $drug['num'];
                $drug['mahuangsu_status'] = 1; // 1：是麻黄素药品
                $canBuyMahuangCount = 4 - $buyed_mahuang_counts - $mahuangsu_num; // 麻黄素药品剩余可购买数量，最多可以购买4个
                if ($canBuyMahuangCount <= 0) {
                    $errMsg = '药品['.$drugModel->name.']剩余购买数量不足~';

                    return $this->failed($errMsg, ['add_status' => false]);
                }
            }
        }

        return $this->success(['add_status' => true]);
    }
}
