<?php

namespace App\Admin\Extensions\Form;

use Dcat\Admin\Widgets\Form;

// use Dcat\Admin\Widgets\Form;
// 全局设置
class SiteConfigForm extends Form
{
    public function handle(array $input)
    {
        $data = [
            'site_config' => $input,
        ];

        admin_setting($data);

        return $this
            ->response()
            ->location('site-config')
            ->success('设置成功');
    }

    /**
     * Build a form here.
     */
    public function form()
    {
        $data = admin_setting('site_config');
        $data = json_decode($data, true);

        $this->number('prescription_limit', '医师开方上限（每天）')->required()->default(($data['prescription_limit'] ?? 0));

        $this->radio('prescription_period_status', '医师开方时间段')
            ->options([1 => '开启', 0 => '关闭'])->when(1, function (Form $form) use ($data) {
                $form->width(4)->time('prescription_period_start', '开始')->format('HH:mm')->rules('required_if:prescription_period_status,1')->setLabelClass(['asterisk'])->default(($data['prescription_period_start'] ?? ''));
                $form->width(4)->time('prescription_period_end', '截止')->format('HH:mm')->rules('required_if:prescription_period_status,1')->setLabelClass(['asterisk'])->default(($data['prescription_period_end'] ?? ''));
            })->default(($data['prescription_period_status'] ?? 0));

        $this->number('prescription_limit_buy_7', '7日内限购(全局)')->required()->default(($data['prescription_limit_buy_7'] ?? 0));

        // $this->switch('prescription_auto', '医师自动开方')->default(($data['prescription_auto'] ?? 0));

        $this->disableResetButton();
    }
}
