<?php

namespace App\Admin\Controllers;

use App\Admin\Extensions\ToolBar\Actions\AddPharmacyDrugAction;
use App\Admin\Repositories\PharmacyDrugRepository;
use App\Models\DosageModel;
use App\Models\DrugModel;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

// 药店-药品
class PharmacyDrugController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new PharmacyDrugRepository(['drug', 'dosage', 'pharmacy']), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');

            $grid->column('id')->sortable();
            $grid->column('pharmacy.name', '药店');
            // $grid->column('drug_id');
            $grid->column('drug.name', '药品名称');
            $grid->column('drug.code', '简码');
            $grid->column('drug.unit', '单位');
            $grid->column('drug.is_rx', '处方药')->using(DrugModel::RX_MAP);
            $grid->column('drug.spec', '规格');
            $grid->column('drug.dosage_form', '剂型');
            $grid->column('drug.factory', '生产厂家');
            $grid->column('drug.approval_no', '批准文号');
            $grid->column('drug.limit_buy_7', '7天限购');
            $grid->column('drug.standard_code', '本位码');
            $grid->column('dosage.dosage_desc', '用法用量');
            $grid->column('batch_no');
            $grid->column('created_at');

            // 工具栏按钮
            $grid->tools(function ($tools) {
                $tools->append(new AddPharmacyDrugAction()); // 新增药品，从药品池导入
            });

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('drug.name', '药品名称')->width(3);
                $filter->like('drug.code', '药品简码')->width(3);
                $filter->like('drug.factory', '生产厂家')->width(3);
            });

            // 行按钮控制
            $grid->disableCreateButton(); // 禁用创建按钮
            $grid->disableDeleteButton(); // 禁用删除按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new PharmacyDrugRepository(['drug', 'dosage', 'pharmacy']), function (Show $show) {
            $show->field('id')->width(4);
            $show->field('pharmacy.name', '药店')->width(4);
            $show->field('drug.name', '药品名称')->width(4);
            $show->field('dosage.dosage_desc', '用法用量')->width(4);
            $show->field('batch_no')->width(4);
            $show->field('created_at')->width(4);
            $show->field('updated_at')->width(4);

            $show->panel()->tools(function ($tools) {
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new PharmacyDrugRepository(['drug', 'dosage', 'pharmacy']), function (Form $form) {
            $form->display('id')->width(4);
            $form->text('pharmacy.name', '药店')->disable()->width(4);
            $form->text('drug.name', '药品名称')->disable()->width(4);
            $disageList = DosageModel::pluck('dosage_desc', 'id');
            $form->select('dosage_id', '用法用量')->options($disageList)->width(4);
            $form->text('batch_no')->width(4);

            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
        });
    }
}
