<?php

namespace App\Http\Middleware;

use Closure;

class CheckRoleChangeMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        $lastLoginType = auth('api')->user()->last_login_type;
        $requestLastLoginType = $request->headers->get('last-login-type') ?: 0;
        if ($lastLoginType != $requestLastLoginType) {
            return response()->json(['status' => false, 'code' => 600, 'message' => '您的角色切换错误~', 'data' => []]);
        }

        return $next($request);
    }
}
