<div class="search-form">
    <div class="input-group mb-3">
        <input type="text" class="form-control" id="prescription_no" placeholder="请输入处方编号">
        <div class="input-group-append">
            <button class="btn btn-primary" type="button" id="search-btn">
                <i class="fa fa-search"></i> 搜索
            </button>
        </div>
    </div>
</div>

<div class="prescription-preview" id="prescription-container" style="display:none">
    <div class="text-center">
        <img id="prescription-image" class="img-fluid" style="max-width:30%">
        <div class="mt-3">
            <button class="btn btn-success" id="download-btn">
                <i class="fa fa-download"></i> 下载处方
            </button>
            
            <button class="btn btn-primary" id="print-btn">
                <i class="fa fa-print"></i> 打印处方
            </button>
        </div>
    </div>
</div>

<script>
Dcat.ready(function () {
    console.log('文档加载完成');
    
    // 初始化处方打印页面
    const prescriptionHandler = new class {
        constructor() {
            console.log('初始化处方处理器');
            this.init();
        }

        init() {
            console.log('开始绑定事件');
            // 绑定搜索事件
            $('#prescription_no').on('keypress', (e) => {
                if (e.which === 13) {
                    console.log('回车搜索触发');
                    this.search();
                }
            });
            
            $('#search-btn').on('click', () => {
                console.log('点击搜索按钮');
                this.search();
            });
            
            $('#download-btn').on('click', () => this.download());
            $('#print-btn').on('click', () => this.print());
            
            console.log('事件绑定完成');
        }

        search() {
            console.log('进入搜索方法');
            let prescriptionNo = $('#prescription_no').val();
            if (!prescriptionNo) {
                Dcat.warning('请输入处方编号');
                return;
            }

            console.log('开始发送请求，处方编号:', prescriptionNo);
            Dcat.loading();
            
            $.ajax({
                url: "{{ admin_url('prescription-search') }}",
                type: 'POST',
                dataType: 'json',
                data: {
                    prescription_no: prescriptionNo,
                    _token: '{{ csrf_token() }}'
                },
                success: (response) => {
                    console.log('请求成功:', response);
                    Dcat.loading(false);
                    
                    if (response.status) {
                        $('#prescription-image').attr('src', response.data.img_url);
                        $('#download-btn').data('url', response.data.img_url);
                        $('#prescription-container').show();
                    } else {
                        Dcat.error(response.message || '获取处方失败');
                    }
                },
                error: (xhr) => {
                    console.error('请求失败:', xhr);
                    Dcat.loading(false);
                    Dcat.error('请求失败，请稍后重试');
                }
            });
        }

        // 下载处方
        download() {
            let url = $('#download-btn').data('url');
            if (!url) {
                Dcat.error('请先搜索处方');
                return;
            }
            window.open(url, '_blank');
        }

        // 打印处方
        print() {
            let url = $('#download-btn').data('url');
            if (!url) {
                Dcat.error('请先搜索处方');
                return;
            }

            // 打开新的打印页面
            let printUrl = '{{ admin_url('print') }}' + '?url=' + url;
            window.open(printUrl, '_blank');
        }

    }();  // 注意这里立即实例化类
});
</script>
