<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class DoctorModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'doctor';

    // 医师状态[0=启用,1=禁用]
    const STATUS_FALSE = 0;

    const STATUS_TRUE = 1;

    // 医师状态-文字映射
    const STATUS_MAP = [
        self::STATUS_FALSE => '禁用',
        self::STATUS_TRUE => '启用',
    ];

    // 医师所属于的用户,一对一
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function getSignedPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getLicenseNoPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPhysicianLicenseAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getIdCardFrontPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getIdCardBackPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }
}
