<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('drug_tag_related_inquiry', function (Blueprint $table) {
            $table->comment('药品标签和问诊问题关联表');
            $table->bigIncrements('id');
            $table->bigInteger('tag_id')->comment('药品标签ID');
            $table->bigInteger('inquiry_id')->comment('问诊问题ID');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('drug_tag_related_inquiry');
    }
};
