<?php

namespace App\Api\Controllers;

use App\Common\Util;
use App\Http\Controllers\BaseApiController;
use App\Models\PatientModel;
use Illuminate\Http\Request;

// 问诊人控制器
class PatientController extends BaseApiController
{
    public function test()
    {
        return $this->success(['a' => 1, 'b' => 2, 'c' => 3]);
    }

    // 获取问诊人列表
    public function patientList(Request $request)
    {

        $search_input = $request->input('search_input');
        $query = PatientModel::query();
        if ($search_input) {
            $query->where('mobile', 'like', "%{$search_input}%");
            // ->orWhere('mobile', 'like', "%{$search_input}%");
        }
        $data = $query->paginate(10);

        return $this->success($data);
    }

    // 添加问诊人
    public function add(Request $request)
    {
        $data = $request->all();
        // TODO 表中缺少关联

        // TODO 验证身份证号码是否正确

        $idCardInfo = Util::getIdCardInfo($data['id_card']);
        $data['gender'] = $idCardInfo['gender'];
        $data['age'] = $idCardInfo['age'];
        $res = PatientModel::create($data);
        if ($res) {
            return $this->success($res);
        } else {
            return $this->error(401, '添加失败');
        }
    }

    // 修改问诊人
    public function update(Request $request)
    {
        $id = $request->input('id');
        // TODO 验证身份证号码是否正确

        // TODO 提取身份信息
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->error(401, '该问诊人不存在');
        }
        $data->name = $request->input('name');
        $data->id_card = $request->input('id_card');
        $data->mobile = $request->input('mobile');
        $data->save();
    }

    // 删除问诊人
    public function delete(Request $request)
    {
        $id = $request->input('id');
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->error(401, '该问诊人不存在');
        }
        $data->delete();

        return $this->success($data);
    }

    // 设置默认问诊人
    public function setDefault(Request $request)
    {
        // 通过id找到是否存在默认问诊人，如果存在比对id是否相同，如果不同则修改默认问诊人状态
        // TODO 验证条件待调整
        $id = $request->input('id');
        $data = PatientModel::where('is_default', 1)->where('id', $id)->first();
        if ($data) {
            if ($data['id'] == $id) {
                return $this->success(['msg' => '该问诊人已经是默认问诊人']);
            } else {
                $data->is_default = 0;
                $data->save();
            }
        }
        $id = $request->input('id');
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->error(401, '该问诊人不存在');
        }
        $data->is_default = 1;
        $data->save();

        return $this->success($data);
    }

    // 获取默认问诊人
    public function getDefault(Request $request)
    {
        $id = $request->input('id');
        $data = PatientModel::where('id', $id)->where('is_default', 1)->first();
        if ($data) {
            return $this->success($data);
        } else {
            return $this->error(401, '暂无默认问诊人');
        }
    }
}
