<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PharmacyModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'pharmacy';

    // 药店所属于的用户,一对一
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    // 药店关联的药师,一对多
    public function pharmacy()
    {
        return $this->hasMany(User::class, 'pharmacy_id', 'id');
    }
}
