<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PatientModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'patient';

    // 性别[0=未知,1=男,2=女]
    const SEX_UNDEFINED = 0;

    const SEX_MALE = 1;

    const SEX_FEMALE = 2;

    // 性别-文字映射
    const SEX_MAP = [
        self::SEX_UNDEFINED => '未知',
        self::SEX_MALE => '男',
        self::SEX_FEMALE => '女',
    ];

    // 问诊人所属于的用户,多对一
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }
}
