<?php

namespace App\Api\Controllers;

use App\Common\Util;
use App\Http\Controllers\BaseApiController;
use App\Models\PatientModel;
use App\Models\PharmacyModel;
use App\Models\User;
use Illuminate\Http\Request;

// 问诊人控制器
class PatientController extends BaseApiController
{
    public function test()
    {
        return $this->success(['a' => 1, 'b' => 2, 'c' => 3]);
    }

    // 获取问诊人列表
    public function patientList(Request $request)
    {
        $authInfo = auth('api')->user();
        $query = PatientModel::query();
        if ($authInfo->last_login_type == User::LOGIN_TYPE_USER) {  // 用户
            $query = $query->where('user_id', $authInfo->id);
        } elseif ($authInfo->last_login_type == User::LOGIN_TYPE_PHARMACY) { // 药店
            $pharmacy = PharmacyModel::query()->where('user_id', $authInfo->id)->first();
            $query = $query->where('pharmacy_id', $pharmacy->id);
        }
        $search_input = $request->input('search_input');
        if ($search_input) {
            $query->where('mobile', 'like', "%{$search_input}%");
            // ->orWhere('mobile', 'like', "%{$search_input}%");
        }
        // 分页
        $page = $request->input('page', 1);
        $perPage = $request->input('per_page', 10);
        $data = $query->orderBy('id', 'desc')->paginate($perPage, ['*'], 'page', $page);
        foreach ($data as $key => $value) {
            $data[$key]['age'] = getAgeByIdCard($value['id_card']);
        }

        return $this->success($data);
    }

    // 添加问诊人
    public function add(Request $request)
    {
        $data = $request->all();
        $authInfo = auth('api')->user();
        $patient = new PatientModel;
        if ($authInfo->last_login_type == User::LOGIN_TYPE_USER) {  // 用户
            $patient->user_id = $authInfo->id;
        } elseif ($authInfo->last_login_type == User::LOGIN_TYPE_PHARMACY) { // 药店
            $pharmacy = PharmacyModel::query()->where('user_id', $authInfo->id)->first();
            $patient->pharmacy_id = $pharmacy->id;
        }
        // 验证身份证格式
        if (! validateIdCard($data['id_card'])) {
            return $this->failed('身份证格式错误');
        }

        $idCardInfo = Util::getIdCardInfo($data['id_card']);
        $patient->name = $data['name'];
        $patient->id_card = $data['id_card'];
        $patient->mobile = $data['mobile'];
        $patient->gender = $idCardInfo['gender'];
        $patient->is_default = 0;
        // $res = PatientModel::create($data);
        $res = $patient->save();
        if ($res) {
            return $this->success($res);
        } else {
            return $this->failed('添加失败');
        }
    }

    // 修改问诊人
    public function update(Request $request)
    {
        $id = $request->input('id');
        $id_card = $request->input('id_card');
        // 验证身份证格式
        if (! validateIdCard($id_card)) {
            return $this->failed('身份证格式错误');
        }

        $idCardInfo = Util::getIdCardInfo($id_card);
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->failed('该问诊人不存在');
        }
        $data->name = $request->input('name');
        $data->id_card = $id_card;
        $data->gender = $idCardInfo['gender'];
        $data->mobile = $request->input('mobile');
        $data->save();
    }

    // 删除问诊人
    public function delete(Request $request)
    {
        $id = $request->input('id');
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->failed('该问诊人不存在');
        }
        $data->delete();

        return $this->success($data);
    }

    // 设置默认问诊人
    public function setDefault(Request $request)
    {
        // 通过id找到是否存在默认问诊人，如果存在比对id是否相同，如果不同则修改默认问诊人状态
        // TODO 验证条件待调整
        $authInfo = auth('api')->user();
        // 把该账号下的默认问诊人状态改为0
        $query = PatientModel::where('is_default', 1);
        if ($authInfo->last_login_type == User::LOGIN_TYPE_USER) {
            $query = $query->where('user_id', $authInfo->id);
        } elseif ($authInfo->last_login_type == User::LOGIN_TYPE_PHARMACY) {
            $pharmacy = PharmacyModel::query()->where('user_id', $authInfo->id)->first();
            $query = $query->where('pharmacy_id', $pharmacy->id);
        }
        $defaultPatient = $query->first();
        if ($defaultPatient) {
            $defaultPatient->is_default = 0;
            $defaultPatient->save();
        }
        // 把当前问诊人设为默认
        $id = $request->input('id');
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->failed('该问诊人不存在');
        }
        $data->is_default = 1;
        $data->save();

        return $this->success($data);
    }

    // 获取默认问诊人
    public function getDefault(Request $request)
    {
        $authInfo = auth('api')->user();
        $query = PatientModel::where('is_default', 1);
        $last_login_type = $authInfo->last_login_type;
        $user_id = $authInfo->id;
        if ($last_login_type == User::LOGIN_TYPE_USER) {
            $query = $query->where('user_id', $user_id);
        } elseif ($last_login_type == User::LOGIN_TYPE_PHARMACY) {
            $pharmacy = PharmacyModel::query()->where('user_id', $user_id)->first();
            $query = $query->where('pharmacy_id', $pharmacy->id);
        }
        $data = $query->first();
        if ($data) {
            return $this->success($data);
        } else {
            return $this->failed('暂无默认问诊人');
        }
    }
}
