<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pharmacy', function (Blueprint $table) {
            $table->comment('药店');
            $table->bigIncrements('id');
            $table->string('name', 64)->comment('药店名称');
            $table->string('business_license')->comment('营业执照');
            $table->string('drug_biz_license')->comment('药品经营许可证');
            $table->string('food_biz_license')->comment('食品经营许可证');
            $table->string('med_device_biz_license')->comment('医疗器械经营许可证');
            $table->string('drug_info_service_cert')->comment('互联网药品信息服务资格证书');
            $table->string('pre_packaged_food')->comment('仅销售预包装食品备案表');
            $table->string('area', 64)->comment('地区');
            $table->string('address', 128)->comment('详细地址');
            $table->string('mobile', 11)->comment('药店管理员手机号');
            $table->string('business_hours', 32)->comment('营业时间');
            $table->string('lng', 12)->comment('经度');
            $table->string('lat', 12)->comment('纬度');
            $table->boolean('status')->default(0)->comment('启用[0=未启用,1=启用]');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pharmacy');
    }
};
