<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\PharmacyCorrectionModel;
use App\Models\PharmacyModel;
use Illuminate\Http\Request;

// 药店控制器
class PharmacyController extends BaseApiController
{
    public function test()
    {
        return $this->success(['a' => 1, 'b' => 2, 'c' => 3]);
    }

    public function PharmacyList(Request $request)
    {
        $search_input = $request->input('search_input');
        $query = PharmacyModel::query();
        if ($search_input) {
            $query->where('name', 'like', "%{$search_input}%");
            // ->orWhere('address','like',"%{$search_input}%");
        }
        // TODO 是否闭店、是否在营业时间段、是否启用

        // TODO 该药店下是否有药师在启用状态

        // $data = $query->where('is_close',0)
        //     ->where('is_open',1)
        //     ->where('start_time','<=',date("H:i"))
        //     ->where('end_time','>=',date("H:i"));

        $data = $query->paginate(10);

        return $this->success($data);
    }

    // 获取药店详情
    public function detail($id)
    {
        $authInfo = auth('api')->user();
        $pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
        if (! $pharmacy) {
            return $this->failed('药店信息不存在');
        }

        return $this->success($pharmacy);
    }

    // 药店信息纠错
    public function correction(Request $request)
    {
        $authInfo = auth('api')->user();
        $pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
        if (! $pharmacy) {
            return $this->failed('药店信息不存在');
        }
        $content = $request->input('content');
        if (empty($content)) {
            return $this->failed('纠错内容不能为空');
        }
        $correction = new PharmacyCorrectionModel();
        $correction->pharmacy_id = $pharmacy->id;
        $correction->pharmacy_name = $pharmacy->name;
        $correction->is_handle = PharmacyCorrectionModel::IS_HANDLE_FALSE;
        $correction->content = $content;
        if ($correction->save()) {
            return $this->success('纠错上报成功!');
        } else {
            return $this->failed('纠错失败');
        }
    }

    // 药店审方
    public function approval(Request $request) {}
}
