<?php

if (! function_exists('fen_2_yuan')) {
    /**
     * 分转换成元
     *
     * @param  string  $fen
     * @return string
     */
    function fen_2_yuan($fen)
    {
        return $fen ? bcdiv($fen, '100', 2) : '0';
    }
}

if (! function_exists('yuan_2_fen')) {
    /**
     * 元转换成分
     *
     * @param  string  $yuan
     * @return int
     */
    function yuan_2_fen($yuan)
    {
        $yuan = money_format($yuan); // 首先移除可能存在的千分位逗号

        return intval(bcmul($yuan, '100'));
    }
}

if (! function_exists('money_format')) {
    /**
     * 去除金额千分位逗号
     *
     * @param  string  $yuan
     * @return string
     */
    function money_format($yuan)
    {
        return $yuan ? str_replace(',', '', $yuan) : $yuan;
    }
}

if (! function_exists('object_2_array')) {
    // 对象转换成数组
    function object_2_array($object)
    {
        return array_map('get_object_vars', $object);
    }
}
if (! function_exists('byte_2_human')) {
    // 换算成人可读文件大小
    function byte_2_human($byte) //传入字节单位
    {
        $KB = 1024;
        $MB = $KB * 1024;
        $GB = $MB * 1024;
        $TB = $GB * 1024;
        if ($byte < $KB) {
            return $byte.'B';
        } elseif ($byte < $MB) {
            //取两位小数四舍五入
            return round($byte / $KB, 2).'KB';
        } elseif ($byte < $GB) {
            return round($byte / $MB, 2).'MB';
        } elseif ($byte < $TB) {
            return round($byte / $GB, 2).'GB';
        } else {
            return round($byte / $TB, 2).'TB';
        }
    }
}
if (! function_exists('clean_ids')) {
    /**
     * 清理输入字符串，提取数字ID，并返回一个整数数组或以逗号分隔的字符串。
     *
     * @param  string  $idsString  原始输入字符串，包含多个ID和不同的分隔符
     * @param  bool  $returnArray  是否返回数组，默认为 false，返回字符串
     * @return array|string 返回整数ID数组或以逗号分隔的ID字符串
     */
    function clean_ids($idsString, $returnArray = false)
    {
        // 替换所有非数字字符为英文逗号
        $ids = preg_replace('/[\D]+/', ',', trim($idsString));

        // 移除字符串开头和结尾的逗号
        $ids = trim($ids, ',');

        if (! $returnArray) {
            // 返回处理后的字符串
            return $ids;
        }

        // 分割字符串为数组，并过滤掉空字符串
        $idArr = array_filter(explode(',', $ids), 'strlen');

        // 将数组的每个元素转换为整数并去重
        $idArr = array_unique($idArr);

        return $idArr;
    }
}
if (! function_exists('is_sequential')) {
    function is_sequential($array)
    {
        $minCount = min($array);
        $maxCount = max($array);

        if ($minCount != 1 || $maxCount != count($array)) {
            return false;
        }

        $expectedCounts = range(1, count($array));

        if (array_values($array) != $expectedCounts) {
            return false;
        }

        return true;
    }
}
