<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InquiryModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'inquiry';

    // 问题是否通用[0=不通用,1=通用]
    const INQUIRY_COMMON_FALSE = 0;

    const INQUIRY_COMMON_TRUE = 1;

    // 是否问题是否通用通用-文字映射
    const INQUIRY_COMMON_MAP = [
        self::INQUIRY_COMMON_FALSE => '否',
        self::INQUIRY_COMMON_TRUE => '是',
    ];
}
