<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDiagnosisTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('diagnosis', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->comment('诊断');
            $table->string('content')->comment('显示内容');
            $table->string('code')->comment('诊断编码');
            $table->timestamps();
            $table->softDeletes();
        });
        \DB::statement("ALTER TABLE `patient` comment '诊断'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('diagnosis');
    }
}
