<?php

namespace App\Admin\Extensions\ToolBar\Forms;

use App\Models\Shop\ShopSku;
use App\Service\Shop\ShopMerchantService;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Dcat\Admin\Widgets\Alert;
use Dcat\Admin\Widgets\Form;

class CopySkuBatchForm extends Form implements LazyRenderable
{
    use LazyWidget;

    public function form()
    {
        $info = '1、不选择小程序则还复制到SKU对应小程序<br />';
        $this->html(Alert::make($info, '注意事项')->warning());
        $this->disableResetButton();
        $this->textarea('sku_ids', '已勾选SKUID')->attribute('id', 'batch-ids'); //批量选择的行的id通过隐藏元素 提交时一并传递过去
        $appMap = ShopMerchantService::getAppCodeIdNameMap();
        $this->select('code_id', __('小程序'))->placeholder('请选择复制到哪个小程序')->options($appMap)->help('如果不选择小程序，则还是复制到当前小程序');
        $this->text('original_text', '替换前')->placeholder('多个被替换关键词用竖杠 | 隔开。例如：洁柔|维达')->help('例如将SKU标题中品牌名称替换成另一个品牌名称，不填则不替换。');
        $this->text('modified_text', '替换后')->placeholder('填写需要被替换成的关键词')->help('如果不填，则是将文字替换为空');
    }

    public function handle(array $input)
    {
        $skuIds = $input['sku_ids'];
        $skuIdsArray = clean_ids($skuIds, true);
        if (! $skuIdsArray) {
            return $this->response()->error('请选择至少一个SKU')->refresh();
        }
        $codeId = $input['code_id'] ?? '';
        $originalText = explode('|', $input['original_text']);
        $modifiedText = $input['modified_text'] ?? '';

        // 复制数据
        $newIds = [];
        foreach ($skuIdsArray as $primaryId) {
            $qb = ShopSku::find($primaryId)->replicate(['online_status', 'sale_num']);
            if ($codeId) {
                $qb->code_id = $codeId;
            }
            if ($originalText) {
                $qb->title = str_replace($originalText, $modifiedText, $qb->title);
            }
            $qb->save();
            $newIds[] = $qb->id;
        }

        // 返回响应结果并刷新页面
        $newIdsString = implode(',', $newIds);

        return $this->response()->alert(true)->success('批量复制成功。新ID：')->detail($newIdsString)->refresh();

    }
}
