<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class PrescriptionModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'prescription';

    // 审方状态[0=待开方,1=待审方,2=审方成功]
    const PRESCRIPTION_STATUS_PENDING = 0;

    const PRESCRIPTION_STATUS_REVIEWING = 1;

    const PRESCRIPTION_STATUS_SUCCESS = 2;

    // 审方状态-文字映射
    const PRESCRIPTION_STATUS_MAP = [
        self::PRESCRIPTION_STATUS_PENDING => '待开方',
        self::PRESCRIPTION_STATUS_REVIEWING => '待审方',
        self::PRESCRIPTION_STATUS_SUCCESS => '审方成功',
    ];

    // 开方来源[0=客开,1=店开]
    const OPEN_SOURCE_CUSTOMER = 0;

    const OPEN_SOURCE_PHARMACY = 1;

    // 开方来源-文字映射
    const OPEN_SOURCE_MAP = [
        self::OPEN_SOURCE_CUSTOMER => '客开',
        self::OPEN_SOURCE_PHARMACY => '店开',
    ];

    public function getDoctorSignedPicAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPharmacistSignedPicAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPrescriptionPicAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }
}
