<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

// 药店
class PharmacyModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'pharmacy';

    // 药店所属于的用户,一对一
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    // 药店关联的药师,一对多
    public function pharmacist()
    {
        return $this->hasMany(PharmacistModel::class, 'pharmacist_id', 'id');
    }

    // 药店关联的问诊人,一对多
    public function patient()
    {
        return $this->hasMany(PatientModel::class, 'patient_id', 'id');
    }

    public function getDrugBizLicenseAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getBusinessLicenseAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getFoodBizLicenseAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getMedDeviceBizLicenseAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getDrugInfoServiceCertAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }

    public function getPrePackagedFoodAttribute($value)
    {
        if (Str::contains($value, '//')) {
            return $value;
        }

        return Storage::url($value);
    }
}
