<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDoctorCorrectionTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('doctor_correction', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('doctor_id')->comment('医师编号');
            $table->string('doctor_name')->default('')->comment('医师姓名');
            $table->tinyInteger('is_handle')->comment('是否处理 0 待处理 1 已处理');
            $table->longText('content')->comment('纠错内容');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('doctor_correction');
    }
}
