<?php

namespace App\Admin\Extensions\ToolBar\Forms\Shop;

use App\Service\Common\CommonAppConfigService;
use Dcat\Admin\Contracts\LazyRenderable;
use Dcat\Admin\Traits\LazyWidget;
use Dcat\Admin\Widgets\Form;

class MiniClearCacheForm extends Form implements LazyRenderable
{
    use LazyWidget;

    public function form()
    {
        $this->select('channel', __('小程序'))->options(CommonAppConfigService::getBrandCodeNameMap())->width(4)->required();
    }

    public function handle(array $input)
    {
        $channel = $input['channel'];

        if (! $channel) {
            return $this->response()->error('不能清空配置（请选择小程序）')->refresh();
        }

        $res = CommonAppConfigService::clearAppConfCache($channel);

        return $this->response()->success("清空配置成功 ($channel) ($res)")->refresh();
    }
}
