<?php

namespace App\Admin\Controllers\Common;

use App\Admin\Repositories\Common\ImportLogRepository;
use App\Common\Util;
use App\Models\Common\ImportLogModel;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;

class ImportLogController extends AdminController
{
    /**
     * Make a grid builder.
     */
    protected function grid(): Grid
    {
        return Grid::make(new ImportLogRepository(['operator']), function (Grid $grid) {
            $grid->model()->orderByDesc('id');
            $grid->column('id');
            $grid->column('operator.name', '操作账号');
            $grid->column('item', '导入项')->using(ImportLogModel::IMPORT_ITEM_MAP);
            $grid->column('process_status')->using(ImportLogModel::PROCESS_STATUS_MAP)->dot(ImportLogModel::PROCESS_STATUS_COLOR);
            $grid->column('file_name');
            $grid->column('file_size')->display(function ($v) {
                return byte_2_human($v);
            });
            $grid->column('succeed');
            $grid->column('failed');
            $grid->column('created_at');
            $grid->column('updated_at');

            $grid->actions(function (Grid\Displayers\Actions $actions) {
                // if ($actions->row->failed > 0) {
                // $actions->append(new ImportErrorExportAction('错误信息'));
                // }
            });

            $grid->filter(function (Grid\Filter $filter) {
                $filter->equal('id');
            });

            // 行按钮控制
            $grid->disableRowSelector(); // 禁用行选择器
            $grid->disableDeleteButton(); // 禁用删除按钮
            $grid->disableEditButton(); // 禁用编辑按钮
            $grid->disableViewButton(); // 禁用详情按钮

            // 工具栏按钮控制
            $grid->disableBatchActions(); // 禁用批量操作
            $grid->disableBatchDelete(); // 禁用批量删除
            $grid->disableCreateButton(); // 禁用创建按钮
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail(int $id)
    {
        return Util::noAuth();
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Util::noAuth();
    }
}
