<?php

namespace App\Api\Controllers;

use App\Common\Util;
use App\Http\Controllers\BaseApiController;
use App\Models\PatientModel;
use Illuminate\Http\Request;

// 问诊人控制器
class PatientController extends BaseApiController
{
    public function test()
    {
        return $this->success(['a' => 1, 'b' => 2, 'c' => 3]);
    }

    // 获取问诊人列表
    public function patientList(Request $request)
    {
        $login_type = $request->input('login_type');
        $id = $request->input('id');
        $query = PatientModel::query();
        if ($login_type == 0) {  // 用户
            $query = $query->where('user_id', $id);
        } elseif ($login_type == 2) { // 药店
            $query = $query->where('pharmacy_id', $id);
        }
        $search_input = $request->input('search_input');
        if ($search_input) {
            $query->where('mobile', 'like', "%{$search_input}%");
            // ->orWhere('mobile', 'like', "%{$search_input}%");
        }
        $data = $query->paginate(10);

        return $this->success($data);
    }

    // 添加问诊人
    public function add(Request $request)
    {
        $data = $request->all();
        // TODO 表中缺少关联

        // TODO 验证身份证号码是否正确

        $idCardInfo = Util::getIdCardInfo($data['id_card']);
        $data['gender'] = $idCardInfo['gender'];
        // $data['age'] = $idCardInfo['age'];
        $res = PatientModel::create($data);
        if ($res) {
            return $this->success($res);
        } else {
            return $this->error(401, '添加失败');
        }
    }

    // 修改问诊人
    public function update(Request $request)
    {
        $id = $request->input('id');
        $id_card = $request->input('id_card');

        // TODO 提取身份信息
        $idCardInfo = Util::getIdCardInfo($id_card);
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->error(401, '该问诊人不存在');
        }
        $data->name = $request->input('name');
        $data->id_card = $id_card;
        $data->gender = $idCardInfo['gender'];
        $data->mobile = $request->input('mobile');
        $data->save();
    }

    // 删除问诊人
    public function delete(Request $request)
    {
        $id = $request->input('id');
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->error(401, '该问诊人不存在');
        }
        $data->delete();

        return $this->success($data);
    }

    // 设置默认问诊人
    public function setDefault(Request $request)
    {
        // 通过id找到是否存在默认问诊人，如果存在比对id是否相同，如果不同则修改默认问诊人状态
        // TODO 验证条件待调整
        $login_type = $request->input('login_type');
        $uid = $request->input('uid');
        // 把该账号下的默认问诊人状态改为0
        $query = PatientModel::where('id', $uid)->where('is_default', 1);
        if ($login_type == 0) {
            $query = $query->where('user_id', $uid);
        } elseif ($login_type == 2) {
            $query = $query->where('pharmacy_id', $uid);
        }
        $data = $query->first();
        if ($data) {
            $data->is_default = 0;
            $data->save();
        }
        // 把当前问诊人设为默认
        $id = $request->input('id');
        $data = PatientModel::find($id);
        if (! $data) {
            return $this->error(401, '该问诊人不存在');
        }
        $data->is_default = 1;
        $data->save();

        return $this->success($data);
    }

    // 获取默认问诊人
    public function getDefault(Request $request)
    {
        $login_type = $request->input('login_type');
        $id = $request->input('id');
        $query = PatientModel::where('is_default', 1);
        if ($login_type == 0) {
            $query = $query->where('user_id', $id);
        } elseif ($login_type == 2) {
            $query = $query->where('pharmacy_id', $id);
        }
        $data = $query->first();
        if ($data) {
            return $this->success($data);
        } else {
            return $this->error(401, '暂无默认问诊人');
        }
    }
}
