<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\PatientModel;
use App\Models\PharmacyCorrectionModel;
use App\Models\PharmacyModel;
use App\Models\PrescriptionLogModel;
use App\Models\PrescriptionModel;
use Carbon\Carbon;
use Illuminate\Http\Request;

// 药店控制器
class PharmacyController extends BaseApiController
{
    public function test()
    {
        return $this->success(['a' => 1, 'b' => 2, 'c' => 3]);
    }

    public function PharmacyList(Request $request)
    {
        $search_input = $request->input('search_input');
        $query = PharmacyModel::query();
        if ($search_input) {
            $query->where('name', 'like', "%{$search_input}%");
            // ->orWhere('address','like',"%{$search_input}%");
        }
        // TODO 是否闭店、是否在营业时间段、是否启用

        // TODO 该药店下是否有药师在启用状态

        // $data = $query->where('is_close',0)
        //     ->where('is_open',1)
        //     ->where('start_time','<=',date("H:i"))
        //     ->where('end_time','>=',date("H:i"));

        $data = $query->paginate(10);

        return $this->success($data);
    }

    // 获取药店详情
    public function detail($id)
    {
        $authInfo = auth('api')->user();
        $pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
        if (! $pharmacy) {
            return $this->failed('药店信息不存在');
        }

        return $this->success($pharmacy);
    }

    // 药店信息纠错
    public function correction(Request $request)
    {
        $authInfo = auth('api')->user();
        $pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
        if (! $pharmacy) {
            return $this->failed('药店信息不存在');
        }
        $content = $request->input('content');
        if (empty($content)) {
            return $this->failed('纠错内容不能为空');
        }
        $correction = new PharmacyCorrectionModel();
        $correction->pharmacy_id = $pharmacy->id;
        $correction->pharmacy_name = $pharmacy->name;
        $correction->is_handle = PharmacyCorrectionModel::IS_HANDLE_FALSE;
        $correction->content = $content;
        if ($correction->save()) {
            return $this->success('纠错上报成功!');
        } else {
            return $this->failed('纠错失败');
        }
    }

    // 药店审方
    public function prescription(Request $request)
    {
        $id = $request->input('id');
        if (empty($id) || ! filter_var($id, FILTER_VALIDATE_INT)) {
            return $this->failed('ID 不能为空且必须为整数');
        }
        $authInfo = auth('api')->user();
        $Pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
        if (! $Pharmacy) {
            return $this->failed('药店信息不存在');
        }
        $prescription = PrescriptionModel::where('id', $id)->where('pharmacy_id', $Pharmacy->id)->where('status', PrescriptionModel::PRESCRIPTION_STATUS_REVIEWING)->first();
        if ($prescription) {
            return $this->failed('该处方已审核');
        }
        $prescription->status = PrescriptionModel::PRESCRIPTION_STATUS_SUCCESS;
        if ($prescription->save()) {

            $patient_id = $prescription->patient_id;
            $patient = PatientModel::where('id', $patient_id)->first();
            // TODO 增加审方日志
            $pharmacistLog = new PrescriptionLogModel;
            $pharmacistLog->pharmacy_id = $prescription->pharmacy_id;
            $pharmacistLog->pharmacy_name = $prescription->pharmacy_name;
            $currentTime = Carbon::now()->toDateTimeString();
            $pharmacistLog->log_info = $prescription->pharmacist_name.'在'.$currentTime.'为'.$prescription->patient_name.'（'.$patient->mobile.'）审方(处方单编号：'.$prescription->id.')';
            $pharmacistLog->save();

            return $this->success('审方成功');
        } else {
            return $this->failed('审方失败');
        }
    }
}
