<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateMedicalTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('medical', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('visitNo')->default('')->comment('580问诊编号');
            $table->string('idcardTypeCode')->default('')->comment('患者就诊卡证类型');
            $table->string('idcardNo')->default('')->comment('患者就诊卡证号码');
            $table->string('name')->default('')->comment('姓名');
            $table->string('genderCode')->default('')->comment('性别代码');
            $table->string('birthdate')->default('')->comment('出生日期');
            $table->string('guardName')->default('')->comment('监护人姓名');
            $table->string('guardIdcardNo')->default('')->comment('监护人身份证号码');
            $table->longText('subjComplaint')->comment('主诉记录');
            $table->text('mainSymptoms')->comment('主要监测症状代码组合');
            $table->longText('prexHx')->comment('病史描述');
            $table->string('prevHist')->default('')->comment('现病史');
            $table->string('pastHist')->default('')->comment('既往史');
            $table->string('alleHist')->default('')->comment('过敏史');
            $table->string('tcmDdCode')->default('')->comment('中医疾病诊断代码');
            $table->string('tcmDdName')->default('')->comment('中医疾病诊断名称');
            $table->string('tcmSdCode')->default('')->comment('中医证候诊断代码');
            $table->string('tcmSdName')->default('')->comment('中医证候诊断名称');
            $table->string('mdDisCode')->default('')->comment('西医诊断疾病代码');
            $table->string('mdDisName')->default('')->comment('西医诊断疾病名称');
            $table->string('disCode1')->default('')->comment('其他诊断①疾病代码');
            $table->string('disName1')->default('')->comment('其他诊断①疾病名称');
            $table->string('disCode2')->default('')->comment('其他诊断②疾病代码');
            $table->string('disName2')->default('')->comment('其他诊断②疾病名称');
            $table->text('disDescription')->comment('医生对门诊诊断的描述');
            $table->longText('treatMeas')->comment('处理措施');
            $table->string('unifiedOrgCode')->default('')->comment('就诊医疗机构编码');
            $table->string('orgName')->default('')->comment('就诊医疗机构名称');
            $table->string('deptCode')->default('')->comment('就诊科室编码');
            $table->string('deptName')->default('')->comment('就诊科室名称');
            $table->string('deptClassCode')->default('')->comment('就诊科室对应诊疗科目编码');
            $table->string('deptClassName')->default('')->comment('就诊科室对应诊疗科目名称');
            $table->string('doctIdcardNo')->default('')->comment('就诊医师身份证号');
            $table->string('doctName')->default('')->comment('就诊医师姓名');
            $table->string('visitTimeStart')->default('')->comment('就诊开始时间');
            $table->string('visitTimeEnd')->default('')->comment('诊断结束时间');
            $table->longText('doctCaSign')->comment('就诊医师电子签名');
            $table->longText('originalData')->comment('数据原文');
            $table->longText('certificate')->comment('数字证书');
            $table->text('reviewUrl')->comment('诊疗过程调阅地址');
            $table->longText('firstVisitRecord')->comment('线下初诊记录');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('medical');
    }
}
