<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('doctor', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name', 50)->index('idx_name')->comment('姓名');
            $table->string('mobile', 11)->index('idx_mobile')->comment('手机号');
            $table->string('id_card', 18)->comment('身份证号码');
            $table->string('license_no', 30)->comment('执照编号');
            $table->string('license_no_pic')->comment('执行证书');
            $table->string('license_no_period')->comment('执行证书有效期');
            $table->string('physician_license', 30)->comment('执业资格证书');
            $table->string('id_card_front_pic')->comment('身份证正面照');
            $table->string('id_card_back_pic')->comment('身份证反面照');
            $table->string('online_hospital_name', 128)->comment('互联网医院名称');
            $table->string('department', 128)->comment('科室');
            $table->string('doctor_title', 64)->comment('职称');
            $table->text('be_good_at')->nullable()->comment('擅长');
            $table->text('introduction')->nullable()->comment('简介');
            $table->boolean('status')->default(0)->comment('是否启用[0=未启用，1=启用]');
            $table->text('signed_pic')->nullable()->comment('签名照');
            $table->timestamps();
            $table->softDeletes();
        });
        \DB::statement("ALTER TABLE `doctor` comment '医师'");
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('doctor');
    }
};
