<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\DosageRepository;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Layout\Content;
use Dcat\Admin\Show;

// 用法用量
class DosageController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new DosageRepository('pharmacy'), function (Grid $grid) {
            // 权限判断和数据过滤
            if (! Admin::user()->pharmacy_id) {
                admin_exit(Content::make()->withError(trans('admin.deny')));
            }

            $grid->model()->orderBy('id', 'DESC');

            $grid->model()->where('pharmacy_id', Admin::user()->pharmacy_id);
            $grid->column('id')->sortable();
            $grid->column('pharmacy.name', '药店');
            $grid->column('dosage_desc');
            $grid->column('dosage_show');

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('dosage_desc')->width(3);
            });

            // 行按钮控制
            $grid->disableDeleteButton(); // 禁用删除按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        admin_exit(Content::make()->withError(trans('admin.deny')));

        return Show::make($id, new DosageRepository(), function (Show $show) {
            $show->field('id');
            $show->field('dosage_desc');
            $show->field('dosage_show');
            $show->field('created_at');
            $show->field('updated_at');

            $show->panel()->tools(function ($tools) {
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new DosageRepository(), function (Form $form) {
            // 权限判断和数据过滤
            if (! Admin::user()->pharmacy_id) {
                admin_exit(Content::make()->withError(trans('admin.deny')));
            }
            if ($form->isEditing() && (Admin::user()->pharmacy_id != $form->model()->pharmacy_id)) {
                admin_exit(Content::make()->withError(trans('admin.deny')));
            }
            $form->display('id')->width(4);
            $form->hidden('pharmacy_id');
            $form->text('dosage_desc')->width(4)->required();
            $form->textarea('dosage_show')->width(4)->required();

            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            $form->saving(function (Form $form) {
                // 不能动
                $form->pharmacy_id = Admin::user()->pharmacy_id;
            });
            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
        });
    }
}
