<?php

namespace App\Api\Controllers;

use App\Http\Controllers\BaseApiController;
use App\Models\PharmacyModel;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class SiteConfigController extends BaseApiController
{
    public function test()
    {
        $site_config = admin_setting_array('site_config');
        Log::info('测试', $site_config);
        $data = [
            'diagnosis_limit' => $site_config['diagnosis_limit'],
            'drug_choose_limit' => $site_config['drug_choose_limit'],
        ];

        return $this->success($data);
    }

    public function config(Request $request)
    {
        $site_config = admin_setting_array('site_config');
        // Log::info('测试', $site_config);
        $data = [
            'diagnosis_limit' => $site_config['diagnosis_limit'],
            'drug_choose_limit' => $site_config['drug_choose_limit'],
            'doses_limit' => $site_config['doses_limit'],
        ];

        return $this->success($data);
    }

    public function isYBOpen(Request $request)
    {
        $is_open_yb = 0;
        $authInfo = auth('api')->user();
        if ($authInfo->last_login_type == User::LOGIN_TYPE_PHARMACY) {
            $pharmacy = PharmacyModel::where('user_id', $authInfo->id)->first();
            if ($pharmacy) {
                $is_open_yb = $pharmacy->is_yb_open;
            }
        }
        $data = [
            'is_open_yb' => $is_open_yb,
        ];

        return $this->success($data);
    }
}
