<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pharmacist', function (Blueprint $table) {
            $table->comment('药师');
            $table->bigIncrements('id');
            $table->string('name', 50)->comment('姓名');
            $table->string('id_card', 18)->comment('身份证号');
            $table->string('license_number', 32)->comment('执照编号');
            $table->string('mobile', 11)->comment('手机号码');
            $table->string('practicing_license')->comment('执业注册证书');
            $table->date('practicing_license_expired_time')->comment('执业注册证书有效期');
            $table->string('physician_license')->comment('执业资格证书');
            $table->longText('signed_pic')->nullable()->comment('签名照');
            $table->boolean('status')->default(0)->comment('启用[0=未启用,1=启用]');
            $table->boolean('is_default')->default(0)->comment('默认药师[0=否,1=是]');
            $table->bigInteger('pharmacy_id')->index('idx_pharmacyid')->comment('药店ID');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pharmacist');
    }
};
