<?php

namespace Database\Seeders;

use DB;
use Dcat\Admin\Models;
use Illuminate\Database\Seeder;

class AdminTablesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // base tables
        Models\Menu::truncate();
        Models\Menu::insert(
            [
                [
                    'id' => 1,
                    'parent_id' => 0,
                    'order' => 1,
                    'title' => '首页',
                    'icon' => 'feather icon-bar-chart-2',
                    'uri' => '/',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-03 23:16:45',
                ],
                [
                    'id' => 2,
                    'parent_id' => 0,
                    'order' => 26,
                    'title' => '权限管理',
                    'icon' => 'feather icon-settings',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 3,
                    'parent_id' => 2,
                    'order' => 27,
                    'title' => '管理员',
                    'icon' => null,
                    'uri' => 'auth/users',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 4,
                    'parent_id' => 2,
                    'order' => 28,
                    'title' => '角色',
                    'icon' => null,
                    'uri' => 'auth/roles',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 5,
                    'parent_id' => 2,
                    'order' => 29,
                    'title' => '权限',
                    'icon' => null,
                    'uri' => 'auth/permissions',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 6,
                    'parent_id' => 2,
                    'order' => 30,
                    'title' => '菜单',
                    'icon' => null,
                    'uri' => 'auth/menu',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 7,
                    'parent_id' => 2,
                    'order' => 31,
                    'title' => '扩展',
                    'icon' => null,
                    'uri' => 'auth/extensions',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 8,
                    'parent_id' => 2,
                    'order' => 32,
                    'title' => '操作日志',
                    'icon' => 'fa-500px',
                    'uri' => 'auth/operation-logs',
                    'extension' => 'dcat-admin.operation-log',
                    'show' => 1,
                    'created_at' => '2024-11-03 02:13:40',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 9,
                    'parent_id' => 0,
                    'order' => 2,
                    'title' => '药品',
                    'icon' => 'fa-delicious',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:31:50',
                    'updated_at' => '2024-11-06 16:18:28',
                ],
                [
                    'id' => 10,
                    'parent_id' => 9,
                    'order' => 3,
                    'title' => '诊断',
                    'icon' => null,
                    'uri' => 'diagnosi',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:32:12',
                    'updated_at' => '2024-11-04 13:47:23',
                ],
                [
                    'id' => 11,
                    'parent_id' => 9,
                    'order' => 4,
                    'title' => '药品池',
                    'icon' => null,
                    'uri' => 'drug',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:32:28',
                    'updated_at' => '2024-11-06 16:18:45',
                ],
                [
                    'id' => 12,
                    'parent_id' => 0,
                    'order' => 7,
                    'title' => '问诊',
                    'icon' => 'fa-adjust',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:32:49',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 13,
                    'parent_id' => 12,
                    'order' => 8,
                    'title' => '问诊人列表',
                    'icon' => null,
                    'uri' => 'patient',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:33:08',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 14,
                    'parent_id' => 12,
                    'order' => 9,
                    'title' => '问诊问题',
                    'icon' => null,
                    'uri' => 'inquiry',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:33:19',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 15,
                    'parent_id' => 0,
                    'order' => 10,
                    'title' => '医师',
                    'icon' => 'fa-shirtsinbulk',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:33:46',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 16,
                    'parent_id' => 15,
                    'order' => 11,
                    'title' => '医师列表',
                    'icon' => null,
                    'uri' => 'doctor',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:33:58',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 17,
                    'parent_id' => 0,
                    'order' => 13,
                    'title' => '药店',
                    'icon' => 'fa-bank',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:19',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 18,
                    'parent_id' => 17,
                    'order' => 14,
                    'title' => '药店列表',
                    'icon' => null,
                    'uri' => 'pharmacy',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:31',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 19,
                    'parent_id' => 17,
                    'order' => 15,
                    'title' => '药师列表',
                    'icon' => null,
                    'uri' => 'pharmacist',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:38',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 20,
                    'parent_id' => 0,
                    'order' => 17,
                    'title' => '处方',
                    'icon' => 'fa-address-card-o',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:48',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 21,
                    'parent_id' => 20,
                    'order' => 18,
                    'title' => '处方列表',
                    'icon' => null,
                    'uri' => 'prescription',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:34:59',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 22,
                    'parent_id' => 20,
                    'order' => 19,
                    'title' => '处方日志',
                    'icon' => null,
                    'uri' => 'prescription-log',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:35:09',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 23,
                    'parent_id' => 0,
                    'order' => 22,
                    'title' => '药品管理',
                    'icon' => 'fa-book',
                    'uri' => 'pharmacy-drug',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:38:11',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 25,
                    'parent_id' => 0,
                    'order' => 23,
                    'title' => '用法用量',
                    'icon' => 'fa-briefcase',
                    'uri' => 'dosage',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:38:57',
                    'updated_at' => '2024-11-11 00:38:00',
                ],
                [
                    'id' => 27,
                    'parent_id' => 0,
                    'order' => 24,
                    'title' => '处方打印',
                    'icon' => 'fa-print',
                    'uri' => 'prescription-print',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-03 23:39:30',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 29,
                    'parent_id' => 9,
                    'order' => 5,
                    'title' => '药品标签',
                    'icon' => null,
                    'uri' => 'drug-tag',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:18:58',
                    'updated_at' => '2024-11-11 15:28:17',
                ],
                [
                    'id' => 30,
                    'parent_id' => 15,
                    'order' => 12,
                    'title' => '医师纠错',
                    'icon' => null,
                    'uri' => 'doctor-correction',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:19:46',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 31,
                    'parent_id' => 17,
                    'order' => 16,
                    'title' => '药店纠错',
                    'icon' => null,
                    'uri' => 'pharmacy-correction',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:20:36',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 32,
                    'parent_id' => 0,
                    'order' => 20,
                    'title' => '系统',
                    'icon' => 'fa-keyboard-o',
                    'uri' => null,
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:21:08',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 34,
                    'parent_id' => 32,
                    'order' => 21,
                    'title' => '设置',
                    'icon' => null,
                    'uri' => 'site-config',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-06 16:23:54',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 35,
                    'parent_id' => 9,
                    'order' => 6,
                    'title' => '药品单位',
                    'icon' => null,
                    'uri' => 'drug-unit',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-13 21:18:24',
                    'updated_at' => '2024-11-19 13:55:26',
                ],
                [
                    'id' => 36,
                    'parent_id' => 0,
                    'order' => 25,
                    'title' => '药店配置',
                    'icon' => 'fa-connectdevelop',
                    'uri' => 'pharmacy-config',
                    'extension' => '',
                    'show' => 1,
                    'created_at' => '2024-11-19 13:55:17',
                    'updated_at' => '2024-11-19 13:55:44',
                ],
            ]
        );

        Models\Permission::truncate();
        Models\Permission::insert(
            [
                [
                    'id' => 1,
                    'name' => '权限管理',
                    'slug' => 'auth-management',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 25,
                    'parent_id' => 0,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 15:37:55',
                ],
                [
                    'id' => 2,
                    'name' => '管理员',
                    'slug' => 'users',
                    'http_method' => '',
                    'http_path' => '/auth/users*',
                    'order' => 26,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 15:37:55',
                ],
                [
                    'id' => 3,
                    'name' => '角色',
                    'slug' => 'roles',
                    'http_method' => '',
                    'http_path' => '/auth/roles*',
                    'order' => 27,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 15:37:55',
                ],
                [
                    'id' => 4,
                    'name' => '权限',
                    'slug' => 'permissions',
                    'http_method' => '',
                    'http_path' => '/auth/permissions*',
                    'order' => 28,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 15:37:55',
                ],
                [
                    'id' => 5,
                    'name' => '菜单',
                    'slug' => 'menu',
                    'http_method' => '',
                    'http_path' => '/auth/menu*',
                    'order' => 29,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 15:37:55',
                ],
                [
                    'id' => 6,
                    'name' => '扩展',
                    'slug' => 'extension',
                    'http_method' => '',
                    'http_path' => '/auth/extensions*',
                    'order' => 30,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-19 15:37:55',
                ],
                [
                    'id' => 7,
                    'name' => '操作日志',
                    'slug' => 'auth.operationlog',
                    'http_method' => '',
                    'http_path' => 'auth/operation-logs*',
                    'order' => 31,
                    'parent_id' => 1,
                    'created_at' => '2024-11-03 23:20:09',
                    'updated_at' => '2024-11-19 15:37:55',
                ],
                [
                    'id' => 8,
                    'name' => '药品',
                    'slug' => 'yaopin',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 1,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:26:09',
                    'updated_at' => '2024-11-13 22:34:40',
                ],
                [
                    'id' => 9,
                    'name' => '诊断',
                    'slug' => 'diagnosi',
                    'http_method' => '',
                    'http_path' => 'diagnosi*',
                    'order' => 2,
                    'parent_id' => 8,
                    'created_at' => '2024-11-13 22:26:58',
                    'updated_at' => '2024-11-13 22:35:02',
                ],
                [
                    'id' => 10,
                    'name' => '药品池',
                    'slug' => 'drug',
                    'http_method' => '',
                    'http_path' => 'drug*,drug-template',
                    'order' => 3,
                    'parent_id' => 8,
                    'created_at' => '2024-11-13 22:27:21',
                    'updated_at' => '2024-11-20 15:48:37',
                ],
                [
                    'id' => 11,
                    'name' => '药品标签',
                    'slug' => 'drug-tag',
                    'http_method' => '',
                    'http_path' => 'drug-tag*',
                    'order' => 4,
                    'parent_id' => 8,
                    'created_at' => '2024-11-13 22:27:59',
                    'updated_at' => '2024-11-13 22:35:22',
                ],
                [
                    'id' => 12,
                    'name' => '药品单位',
                    'slug' => 'drug-unit',
                    'http_method' => '',
                    'http_path' => 'drug-unit*',
                    'order' => 5,
                    'parent_id' => 8,
                    'created_at' => '2024-11-13 22:28:23',
                    'updated_at' => '2024-11-13 22:35:27',
                ],
                [
                    'id' => 13,
                    'name' => '问诊',
                    'slug' => 'wenzhen',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 6,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:29:16',
                    'updated_at' => '2024-11-13 22:35:35',
                ],
                [
                    'id' => 14,
                    'name' => '问诊人列表',
                    'slug' => 'patient',
                    'http_method' => '',
                    'http_path' => 'patient*',
                    'order' => 7,
                    'parent_id' => 13,
                    'created_at' => '2024-11-13 22:29:50',
                    'updated_at' => '2024-11-13 22:35:49',
                ],
                [
                    'id' => 15,
                    'name' => '问诊问题',
                    'slug' => 'inquiry',
                    'http_method' => '',
                    'http_path' => 'inquiry*',
                    'order' => 8,
                    'parent_id' => 13,
                    'created_at' => '2024-11-13 22:30:20',
                    'updated_at' => '2024-11-13 22:35:57',
                ],
                [
                    'id' => 16,
                    'name' => '医师',
                    'slug' => 'yishi',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 9,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:30:40',
                    'updated_at' => '2024-11-13 22:36:03',
                ],
                [
                    'id' => 17,
                    'name' => '医师列表',
                    'slug' => 'doctor',
                    'http_method' => '',
                    'http_path' => 'doctor*',
                    'order' => 10,
                    'parent_id' => 16,
                    'created_at' => '2024-11-13 22:31:09',
                    'updated_at' => '2024-11-13 22:36:08',
                ],
                [
                    'id' => 18,
                    'name' => '医师纠错',
                    'slug' => 'doctor-correction',
                    'http_method' => '',
                    'http_path' => 'doctor-correction*',
                    'order' => 11,
                    'parent_id' => 16,
                    'created_at' => '2024-11-13 22:31:37',
                    'updated_at' => '2024-11-13 22:36:14',
                ],
                [
                    'id' => 19,
                    'name' => '药店',
                    'slug' => 'yaodian',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 12,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:31:59',
                    'updated_at' => '2024-11-13 22:36:19',
                ],
                [
                    'id' => 20,
                    'name' => '药店列表',
                    'slug' => 'pharmacy',
                    'http_method' => '',
                    'http_path' => 'pharmacy*',
                    'order' => 13,
                    'parent_id' => 19,
                    'created_at' => '2024-11-13 22:32:31',
                    'updated_at' => '2024-11-13 22:36:25',
                ],
                [
                    'id' => 21,
                    'name' => '药师列表',
                    'slug' => 'pharmacist',
                    'http_method' => '',
                    'http_path' => 'pharmacist*',
                    'order' => 14,
                    'parent_id' => 19,
                    'created_at' => '2024-11-13 22:33:02',
                    'updated_at' => '2024-11-13 22:33:57',
                ],
                [
                    'id' => 22,
                    'name' => '药店纠错',
                    'slug' => 'pharmacy-correction',
                    'http_method' => '',
                    'http_path' => 'pharmacy-correction*',
                    'order' => 15,
                    'parent_id' => 19,
                    'created_at' => '2024-11-13 22:33:54',
                    'updated_at' => '2024-11-13 22:36:34',
                ],
                [
                    'id' => 23,
                    'name' => '处方',
                    'slug' => 'chufang',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 16,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:34:24',
                    'updated_at' => '2024-11-13 22:36:50',
                ],
                [
                    'id' => 24,
                    'name' => '处方列表',
                    'slug' => 'prescription',
                    'http_method' => '',
                    'http_path' => 'prescription*',
                    'order' => 17,
                    'parent_id' => 23,
                    'created_at' => '2024-11-13 22:37:11',
                    'updated_at' => '2024-11-13 22:37:56',
                ],
                [
                    'id' => 25,
                    'name' => '处方日志',
                    'slug' => 'prescription-log',
                    'http_method' => '',
                    'http_path' => 'prescription-log*',
                    'order' => 18,
                    'parent_id' => 23,
                    'created_at' => '2024-11-13 22:37:30',
                    'updated_at' => '2024-11-13 22:37:56',
                ],
                [
                    'id' => 26,
                    'name' => '系统',
                    'slug' => 'xitong',
                    'http_method' => '',
                    'http_path' => '',
                    'order' => 19,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:37:52',
                    'updated_at' => '2024-11-13 22:37:56',
                ],
                [
                    'id' => 27,
                    'name' => '设置',
                    'slug' => 'site-config',
                    'http_method' => '',
                    'http_path' => 'site-config*',
                    'order' => 20,
                    'parent_id' => 26,
                    'created_at' => '2024-11-13 22:38:16',
                    'updated_at' => '2024-11-13 22:39:33',
                ],
                [
                    'id' => 28,
                    'name' => '药品管理[药店]',
                    'slug' => 'pharmacy-drug',
                    'http_method' => '',
                    'http_path' => 'pharmacy-drug*',
                    'order' => 21,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:38:49',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 29,
                    'name' => '用法用量[药店]',
                    'slug' => 'dosage',
                    'http_method' => '',
                    'http_path' => 'dosage*,dosage-template',
                    'order' => 22,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:39:14',
                    'updated_at' => '2024-12-11 11:00:44',
                ],
                [
                    'id' => 30,
                    'name' => '处方打印[药店]',
                    'slug' => 'prescription-print',
                    'http_method' => '',
                    'http_path' => 'prescription-print*',
                    'order' => 23,
                    'parent_id' => 0,
                    'created_at' => '2024-11-13 22:39:31',
                    'updated_at' => '2024-11-13 22:40:04',
                ],
                [
                    'id' => 31,
                    'name' => '药店配置[药店]',
                    'slug' => 'pharmacy-config',
                    'http_method' => '',
                    'http_path' => 'pharmacy-config*',
                    'order' => 24,
                    'parent_id' => 0,
                    'created_at' => '2024-11-19 15:37:48',
                    'updated_at' => '2024-11-19 15:38:05',
                ],
            ]
        );

        Models\Role::truncate();
        Models\Role::insert(
            [
                [
                    'id' => 1,
                    'name' => 'Administrator',
                    'slug' => 'administrator',
                    'created_at' => '2024-11-03 02:13:11',
                    'updated_at' => '2024-11-03 02:13:11',
                ],
                [
                    'id' => 2,
                    'name' => '药店管理员',
                    'slug' => 'pharmacy',
                    'created_at' => '2024-11-11 00:40:57',
                    'updated_at' => '2024-11-11 00:40:57',
                ],
                [
                    'id' => 4,
                    'name' => '普通管理员',
                    'slug' => 'tgz.administrator',
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
            ]
        );

        Models\Setting::truncate();
        Models\Setting::insert(
            [
                [
                    'slug' => 'guanguans:dcat-login-captcha',
                    'value' => '{"length":4,"charset":"abcdefghijklmnpqrstuvwxyz23456789ABCDEFGHIJKLMNOPQRSTUVWXYZ","width":150,"height":43,"type":"png","font":null,"fingerprint":null,"captcha_phrase_session_key":"login_captcha_phrase"}',
                    'created_at' => '2024-11-03 02:13:44',
                    'updated_at' => '2024-11-03 02:13:44',
                ],
                [
                    'slug' => 'site_config',
                    'value' => '{"prescription_limit":"4","prescription_period_status":"1","prescription_period_start":"18:44","prescription_period_end":"18:44","prescription_limit_buy_7":"5","diagnosis_limit":"1","drug_choose_limit":"5","limit_keywords":"\\u767e\\u90e8"}',
                    'created_at' => '2024-11-18 18:44:46',
                    'updated_at' => '2024-12-03 00:33:09',
                ],
            ]
        );

        Models\Extension::truncate();
        Models\Extension::insert(
            [
                [
                    'id' => 1,
                    'name' => 'dcat-admin.operation-log',
                    'version' => '1.0.0',
                    'is_enabled' => 1,
                    'options' => null,
                    'created_at' => '2024-11-03 02:13:40',
                    'updated_at' => '2024-11-03 02:13:45',
                ],
                [
                    'id' => 3,
                    'name' => 'sparkinzy.dcat-viewer',
                    'version' => '1.0.3',
                    'is_enabled' => 1,
                    'options' => null,
                    'created_at' => '2024-11-03 02:13:42',
                    'updated_at' => '2024-11-03 02:13:43',
                ],
            ]
        );

        Models\ExtensionHistory::truncate();
        Models\ExtensionHistory::insert(
            [
                [
                    'id' => 1,
                    'name' => 'dcat-admin.operation-log',
                    'type' => 2,
                    'version' => '1.0.0',
                    'detail' => 'create_opration_log_table.php',
                    'created_at' => '2024-11-03 02:13:40',
                    'updated_at' => '2024-11-03 02:13:40',
                ],
                [
                    'id' => 2,
                    'name' => 'dcat-admin.operation-log',
                    'type' => 1,
                    'version' => '1.0.0',
                    'detail' => 'Initialize extension.',
                    'created_at' => '2024-11-03 02:13:40',
                    'updated_at' => '2024-11-03 02:13:40',
                ],
                [
                    'id' => 58,
                    'name' => 'sparkinzy.dcat-viewer',
                    'type' => 1,
                    'version' => '1.0.0',
                    'detail' => '基于 神级插件 viewerjs 做的一个封装，提升Dcat Admin 图片预览效果，实现放大、缩小、翻转、旋转等效果.',
                    'created_at' => '2024-11-03 02:13:42',
                    'updated_at' => '2024-11-03 02:13:42',
                ],
                [
                    'id' => 59,
                    'name' => 'sparkinzy.dcat-viewer',
                    'type' => 1,
                    'version' => '1.0.2',
                    'detail' => '提升viewer的zindex为8个9,方便在modal实现图片预览',
                    'created_at' => '2024-11-03 02:13:42',
                    'updated_at' => '2024-11-03 02:13:42',
                ],
                [
                    'id' => 60,
                    'name' => 'sparkinzy.dcat-viewer',
                    'type' => 1,
                    'version' => '1.0.3',
                    'detail' => '新增views目录，便于php artisan optimize',
                    'created_at' => '2024-11-03 02:13:42',
                    'updated_at' => '2024-11-03 02:13:42',
                ],
            ]
        );

        // pivot tables
        DB::table('admin_permission_menu')->truncate();
        DB::table('admin_permission_menu')->insert(
            [

            ]
        );

        DB::table('admin_role_menu')->truncate();
        DB::table('admin_role_menu')->insert(
            [
                [
                    'role_id' => 1,
                    'menu_id' => 1,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 2,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 3,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 4,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 5,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 6,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 7,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 8,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 9,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 10,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 11,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 12,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 13,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 14,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 15,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 16,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 17,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 18,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 19,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 20,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 21,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 22,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 29,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 30,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 31,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 32,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 34,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'menu_id' => 35,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 17,
                    'created_at' => '2024-11-27 18:25:36',
                    'updated_at' => '2024-11-27 18:25:36',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 18,
                    'created_at' => '2024-11-27 18:25:36',
                    'updated_at' => '2024-11-27 18:25:36',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 19,
                    'created_at' => '2024-11-27 19:01:23',
                    'updated_at' => '2024-11-27 19:01:23',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 23,
                    'created_at' => '2024-11-11 00:40:57',
                    'updated_at' => '2024-11-11 00:40:57',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 25,
                    'created_at' => '2024-11-11 00:40:57',
                    'updated_at' => '2024-11-11 00:40:57',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 27,
                    'created_at' => '2024-11-11 00:40:57',
                    'updated_at' => '2024-11-11 00:40:57',
                ],
                [
                    'role_id' => 2,
                    'menu_id' => 36,
                    'created_at' => '2024-11-19 15:38:21',
                    'updated_at' => '2024-11-19 15:38:21',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 9,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 10,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 11,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 12,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 13,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 14,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 15,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 16,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 17,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 18,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 19,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 20,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 21,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 22,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 29,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 30,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 31,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 32,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 34,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 3,
                    'menu_id' => 35,
                    'created_at' => '2024-11-13 22:44:24',
                    'updated_at' => '2024-11-13 22:44:24',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 9,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 10,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 11,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 12,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 13,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 14,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 15,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 16,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 17,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 18,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 19,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 20,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 21,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 22,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 29,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 30,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 31,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 32,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 34,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'menu_id' => 35,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
            ]
        );

        DB::table('admin_role_permissions')->truncate();
        DB::table('admin_role_permissions')->insert(
            [
                [
                    'role_id' => 1,
                    'permission_id' => 2,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 3,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 4,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 5,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 6,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 7,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 9,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 10,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 11,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 12,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 14,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 15,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 17,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 18,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 20,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 21,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 22,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 24,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 25,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 1,
                    'permission_id' => 27,
                    'created_at' => '2024-11-13 22:44:46',
                    'updated_at' => '2024-11-13 22:44:46',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 20,
                    'created_at' => '2024-11-27 18:25:36',
                    'updated_at' => '2024-11-27 18:25:36',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 21,
                    'created_at' => '2024-11-27 19:01:23',
                    'updated_at' => '2024-11-27 19:01:23',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 28,
                    'created_at' => '2024-11-13 22:40:14',
                    'updated_at' => '2024-11-13 22:40:14',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 29,
                    'created_at' => '2024-11-13 22:40:14',
                    'updated_at' => '2024-11-13 22:40:14',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 30,
                    'created_at' => '2024-11-13 22:40:14',
                    'updated_at' => '2024-11-13 22:40:14',
                ],
                [
                    'role_id' => 2,
                    'permission_id' => 31,
                    'created_at' => '2024-11-19 15:38:21',
                    'updated_at' => '2024-11-19 15:38:21',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 9,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 10,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 11,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 12,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 14,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 15,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 17,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 18,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 20,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 21,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 22,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 24,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 25,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
                [
                    'role_id' => 4,
                    'permission_id' => 27,
                    'created_at' => '2024-11-20 15:47:55',
                    'updated_at' => '2024-11-20 15:47:55',
                ],
            ]
        );

        // finish
    }
}
