<?php

namespace App\Models;

use Dcat\Admin\Traits\HasDateTimeFormatter;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;

class DoctorModel extends Model
{
    use HasDateTimeFormatter;
    use SoftDeletes;

    protected $table = 'doctor';

    // 医师所属于的用户,一对一
    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function getSignedPicAttribute($value)
    {
        if (Str::contains($value, '//') || ! $value) {
            return $value;
        }

        return Storage::url($value);
    }
}
