<?php

namespace App\Console\Commands;

use App\Models\InquiryModel;
use App\Models\PrescriptionModel;
use Illuminate\Console\Command;

class TestCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'mohe:test';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = '测试命令';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        // 刷新问诊问题
        $prescriptions = PrescriptionModel::orderBy('id', 'desc')->get();
        foreach ($prescriptions as $prescription) {
            $inquiry_info = $prescription->inquiry_info;
            foreach ($inquiry_info as &$v) {
                $v['question'] = InquiryModel::find($v['inquiry_id'])->question;
            }
            $prescription->inquiry_info = $inquiry_info;
            $prescription->save();
        }
    }
}
