<?php

namespace App\Admin\Controllers;

use App\Admin\Repositories\DrugRepository;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Http\Controllers\AdminController;
use Dcat\Admin\Show;

class DrugController extends AdminController
{
    /**
     * Make a grid builder.
     *
     * @return Grid
     */
    protected function grid()
    {
        return Grid::make(new DrugRepository(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');
            $grid->column('id')->sortable();
            $grid->column('name');
            $grid->column('code');
            $grid->column('unit');
            $grid->column('is_rx', '处方药')->using([0 => '否', 1 => '是']);
            $grid->column('spec');
            $grid->column('dosage_form');
            $grid->column('factory');
            $grid->column('approval_no');
            $grid->column('limit_buy_7');
            $grid->column('tag');
            // $grid->column('created_at');
            // $grid->column('updated_at')->sortable();

            // 快捷搜索
            $grid->quickSearch(['name', 'code', 'factory'])->placeholder('请输入[药品名称/药品简码/生产厂家]')->width(25);

            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('name')->width(3);
                $filter->like('code')->width(3);
                $filter->like('factory')->width(3);

            });

            // 行按钮控制
            $grid->disableDeleteButton(); // 禁用删除按钮

            // 工具栏按钮控制
            $grid->disableBatchDelete(); // 禁用批量删除

            // 导出按钮
            $grid->export()->filename('药品');
        });
    }

    /**
     * Make a show builder.
     *
     * @param  mixed  $id
     * @return Show
     */
    protected function detail($id)
    {
        return Show::make($id, new DrugRepository(), function (Show $show) {
            $show->field('id')->width(4);
            $show->field('name')->width(4);
            $show->field('code')->width(4);
            $show->field('unit')->width(4);
            $show->field('spec')->width(4);
            $show->field('dosage_form')->width(4);
            $show->field('factory')->width(4);
            $show->field('approval_no')->width(4);
            $show->field('limit_buy_7')->width(4);
            $show->field('is_rx')->using([0 => '否', 1 => '是'])->width(4);
            $show->field('tag')->width(4);
            $show->field('created_at')->width(4);
            $show->field('updated_at')->width(4);

            $show->panel()->tools(function ($tools) {
                $tools->disableDelete(); // 禁止删除按钮
            });
        });
    }

    /**
     * Make a form builder.
     *
     * @return Form
     */
    protected function form()
    {
        return Form::make(new DrugRepository(), function (Form $form) {
            $form->display('id')->width(4);
            $form->text('name')->width(4)->required();
            $form->text('code')->width(4)->required();
            $form->text('unit')->width(4)->required();
            $form->text('spec')->width(4)->required();
            $form->text('dosage_form')->width(4)->required();
            $form->text('factory')->width(4)->required();
            $form->text('approval_no')->width(4)->required();
            $array = range(1, 10);
            $limitOption = array_combine($array, $array);
            $form->select('limit_buy_7')->placeholder('请选择限购数量')->width(4)->options($limitOption)->help('限购数量');
            $form->switch('is_rx')->width(4);
            $form->text('tag')->width(4);

            $form->display('created_at')->width(4);
            $form->display('updated_at')->width(4);

            // 右上角按钮控制
            $form->disableDeleteButton(); // 去掉删除按钮
        });
    }
}
