<?php

namespace App\Admin\Renderable;

use App\Models\DrugModel;
use Dcat\Admin\Grid;
use Dcat\Admin\Grid\LazyRenderable;

class DrugTable extends LazyRenderable
{
    public function grid(): Grid
    {
        return Grid::make(new DrugModel(), function (Grid $grid) {
            $grid->model()->orderBy('id', 'DESC');

            $grid->column('id')->sortable();
            $grid->column('name', '药品名称');
            $grid->column('code', '简码');
            $grid->column('unit', '单位');
            $grid->column('is_rx', '处方药')->using(DrugModel::RX_MAP);
            $grid->column('spec', '规格');
            $grid->column('dosage_form', 'dosage_form');
            $grid->column('factory', '生产厂家');
            $grid->column('approval_no', '批准文号');
            $grid->column('limit_buy_7', '7天限购');

            // 复杂搜索
            $grid->filter(function (Grid\Filter $filter) {
                $filter->panel(); // 更改为 panel 布局
                $filter->expand(); // 默认展开搜索框

                $filter->like('name', '药品名称')->width(3);
                $filter->like('code', '简码')->width(3);
                $filter->like('factory', '生产厂家')->width(3);
            });

            // 行按钮控制
            $grid->paginate(10);
            $grid->disableActions();
        });
    }
}
