<?php

use App\Admin\Extensions\Form\JsonEditor;
use Dcat\Admin\Admin;
use Dcat\Admin\Form;
use Dcat\Admin\Grid;
use Dcat\Admin\Grid\Column;

/**
 * Dcat-admin - admin builder based on Laravel.
 *
 * @author jqh <https://github.com/jqhph>
 *
 * Bootstraper for Admin.
 *
 * Here you can remove builtin form field:
 *
 * extend custom field:
 * Dcat\Admin\Form::extend('php', PHPEditor::class);
 * Dcat\Admin\Grid\Column::extend('php', PHPEditor::class);
 * Dcat\Admin\Grid\Filter::extend('php', PHPEditor::class);
 *
 * Or require js and css assets:
 * Admin::css('/packages/prettydocs/css/styles.css');
 * Admin::js('/packages/prettydocs/js/main.js');
 */
// 重写内部视图文件
app('view')->prependNamespace('admin', resource_path('views/admin'));

// json编辑器
Form::extend('json', JsonEditor::class);

// 百度地图
// Form\Field\Map::requireAssets();

Grid::resolving(function (Grid $grid) {
    $grid->withBorder(true); // 默认显示表格边框
});
// Column::resolving(function (Column $column) {
//     $column->setAttributes(['style' => 'font-size:smaller']); // 默认显示表格边框
// });
