<style>
    .login-page {
        padding: 6rem 15rem;
        flex: 1;
        position: relative;
        color: #4B5CC4;
        background-color: rgba(0, 0, 0, 0.3);
        text-align: center !important;
        background: url({{ config('admin.login_background')
    }
    }) center;
    background-size: cover;
    align-items: flex-end !important;
    }

    .login-box {
        margin-top: -10rem;
        padding: 5px;
    }

    .login-logo {
        position: absolute;
        top: 10px;
        left: 20px;
        text-align: left;
    }

    .login-img {
        width: 30px;
    }

    .login-card-body {
        padding: 1.5rem 1.8rem 1.6rem;
    }

    .card,
    .card-body {
        border-radius: .25rem
    }

    .login-btn {
        padding-left: 2rem !important;
        ;
        padding-right: 1.5rem !important;
    }

    .content {
        overflow-x: hidden;
    }

    .form-group .control-label {
        text-align: left;
    }

    .footer-icp {
        position: absolute;
        left: 50%;
        bottom: 0px;
        transform: translateX(-50%);
        width: 100%;
        color: #666;
        font-size: 12px;
        text-align: center;
        padding: 5px 0;
        background-color: #f5f5f5;
    }

    .footer-icp a {
        color: #666;
        text-decoration: none;
    }

    .footer-icp a:hover {
        text-decoration: underline;
    }

    .login-type {
        display: flex;
        width: 200px;
        margin: 0 auto 30px;
        border-radius: 4px;
        overflow: hidden;
    }

    .login-type .type {
        flex: 1;
        text-align: center;
        line-height: 24px;
        font-size: 14px;
        background-color: #ddd;
        color: #333;
        cursor: pointer;
    }

    .login-type .type.active {
        background-color: #6d8be6;
        color: #fff;
    }

    .hide {
        display: none !important;
    }
</style>

<div class="login-page">
    <div class="login-box">
        <div class="login-logo mb-2" style="font-size:1.8rem;font-weight: normal;">
            <img class="avatar img-circle login-img" src="{{ admin_asset('@admin/images/logo.jpg') }}">
            {{ config('admin.name') }}-药店端
            <p style="font-size:0.5rem"></p>
        </div>
        <div class="card">
            <div class="card-body login-card-body shadow-100">
                <p class="login-box-msg mt-1 mb-1">{{ __('admin.welcome_back') }}</p>

                <form id="login-form" method="POST" action="{{ admin_url('auth/login') }}">

                    <input type="hidden" name="_token" value="{{ csrf_token() }}" />
                    <input type="hidden" name="role" value="store" />
                    <input type="hidden" id="login_type" name="type" value="code" />

                    <fieldset class="form-label-group form-group position-relative has-icon-left">
                        <input type="tel" class="form-control {{ $errors->has('username') ? 'is-invalid' : '' }}" name="username" placeholder="手机号" value="{{ old('username') }}" required autofocus pattern="^[0-9]*$" title="请输入有效的手机号">

                        <div class="form-control-position">
                            <i class="feather icon-user"></i>
                        </div>

                        <label for="username">手机号</label>

                        <div class="help-block with-errors"></div>
                        @if($errors->has('username'))
                        <span class="invalid-feedback text-danger" role="alert">
                            @foreach($errors->get('username') as $message)
                            <span class="control-label" for="inputError"><i class="feather icon-x-circle"></i> {{$message}}</span><br>
                            @endforeach
                        </span>
                        @endif
                    </fieldset>

                    <fieldset class="form-label-group form-group position-relative has-icon-left d-flex align-items-center" id="code_row">
                        <input id="verification_code" type="text" class="form-control {{ $errors->has('verification_code') ? 'is-invalid' : '' }}" name="verification_code" placeholder="短信验证码" required style="width: 60%; margin-right: 10px;">
                        <div class="form-control-position">
                            <i class="feather icon-lock"></i>
                        </div>
                        <button type="button" class="btn btn-secondary" id="get-verification-code" onclick="getVerificationCode()">
                            获取验证码
                        </button>
                        <div class="form-control-position" style="display: none;">
                            <i class="feather icon-lock"></i>
                        </div>
                        <label for="verification_code">验证码</label>
                        <div class="help-block with-errors"></div>
                        @if($errors->has('verification_code'))
                        <span class="invalid-feedback text-danger" role="alert">
                            @foreach($errors->get('verification_code') as $message)
                            <span class="control-label" for="inputError"><i class="feather icon-x-circle"></i> {{$message}}</span><br>
                            @endforeach
                        </span>
                        @endif
                    </fieldset>

                    <fieldset class="form-label-group form-group position-relative has-icon-left hide" id="password_row">
                        <input minlength="5" maxlength="20" id="password" type="password" class="form-control " name="password" placeholder="密码" required autocomplete="current-password">

                        <div class="form-control-position">
                            <i class="feather icon-lock"></i>
                        </div>
                        <label for="password">密码</label>

                        <div class="help-block with-errors"></div>

                    </fieldset>
                    <div class="form-group d-flex justify-content-between align-items-center">
                        <div class="text-left">
                            @if(config('admin.auth.remember'))
                            <fieldset class="checkbox">
                                <div class="vs-checkbox-con vs-checkbox-primary">
                                    <input id="remember" name="remember" value="1" type="checkbox" {{ old('remember') ? 'checked' : '' }}>
                                    <span class="vs-checkbox">
                                        <span class="vs-checkbox--check">
                                            <i class="vs-icon feather icon-check"></i>
                                        </span>
                                    </span>
                                    <span> {{ trans('admin.remember_me') }}</span>
                                </div>
                            </fieldset>
                            @endif
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary float-right login-btn">

                        {{ __('admin.login') }}
                        &nbsp;
                        <i class="feather icon-arrow-right"></i>
                    </button>
                </form>

            </div>
        </div>
    </div>
    <div class="footer-icp">
        <a href="https://beian.miit.gov.cn/" rel="noopener noreferrer" target="_blank">网站备案号：苏ICP备2024000133号</a>
    </div>
</div>

<script>
    Dcat.ready(function() {
        // ajax表单提交
        $('#login-form').form({
            validate: true,
        });

    });

    $('#type_passord').click(function() {
        $('login_type').val('password');
        $('#type_passord').addClass('active');
        $('#type_code').removeClass('active');
        $('#password_row').removeClass('hide');
        $('#code_row').addClass('hide');
    })

    $('#type_code').click(function() {
        $('login_type').val('code');
        $('#type_code').addClass('active');
        $('#type_password').removeClass('active');
        $('#code_row').removeClass('hide');
        $('#password_row').addClass('hide');
    })

    let countdown = 60; // 倒计时60秒
    let timer;

    function getVerificationCode() {
        const username = $('input[name="username"]').val();
        if (!username) {
            alert('请输入手机号');
            return;
        }

        // 发送 AJAX 请求获取验证码
        $.ajax({
            url: "{{ admin_url('auth/smscode') }}", // 替换为您的接口地址
            method: 'GET',
            data: {
                username: username,
                _token: '{{ csrf_token() }}'
            },
            success: function(response) {
                if (response.success) {
                    alert('验证码已发送');
                    startCountdown();
                } else {
                    alert(response.error || '获取验证码失败');
                }
            },
            error: function() {
                alert('请求失败，请重试');
            }
        });

    }

    function startCountdown() {
        $('#get-verification-code').prop('disabled', true).text(`重新获取(${countdown}s)`);
        timer = setInterval(function() {
            countdown--;
            $('#get-verification-code').text(`重新获取(${countdown}s)`);
            if (countdown <= 0) {
                clearInterval(timer);
                $('#get-verification-code').prop('disabled', false).text('获取验证码');
                countdown = 60; // 重置倒计时
            }
        }, 1000);
    }
</script>