<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('pharmacy', function (Blueprint $table) {
            $table->comment('药店');

            $table->bigIncrements('id');
            $table->string('name', 64)->comment('药店名称');
            $table->string('business_license')->nullable()->comment('营业执照');
            $table->string('drug_biz_license')->nullable()->comment('药品经营许可证');
            $table->string('food_biz_license')->nullable()->comment('食品经营许可证');
            $table->string('med_device_biz_license')->nullable()->comment('医疗器械经营许可证');
            $table->string('drug_info_service_cert')->nullable()->comment('互联网药品信息服务资格证书');
            $table->string('pre_packaged_food')->nullable()->comment('仅销售预包装食品备案表');
            $table->string('area', 64)->nullable()->comment('地区');
            $table->string('address', 128)->nullable()->comment('详细地址');
            $table->string('mobile', 11)->unique('uk_mobile')->comment('药店管理员手机号');
            $table->time('business_start')->comment('营业开始时间');
            $table->time('business_end')->comment('营业结束时间');
            $table->string('lng', 20)->nullable()->comment('经度');
            $table->string('lat', 20)->nullable()->comment('纬度');
            $table->boolean('status')->default(0)->comment('启用[0=未启用,1=启用]');
            $table->bigInteger('user_id')->nullable()->comment('用户表ID');
            $table->boolean('is_auto')->default(1)->comment('是否自动审方[0=否,1=是]');
            $table->boolean('is_open')->default(0)->comment('是否开店[0=闭店,1=开店]');

            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pharmacy');
    }
};
