<?php

namespace App\Admin\Extensions\ToolRow\Actions;

use Dcat\Admin\Grid\RowAction;
use Illuminate\Http\Request;

class CopyAction extends RowAction
{
    protected $model; // 需要复制的model

    protected $except; // 不需要复制的字段

    public function __construct(?string $model = null, ?array $except = null)
    {
        $this->model = $model;
        $this->except = $except;
    }

    /**
     * 标题
     *
     * @return string
     */
    public function title()
    {
        return "<i class='fa fa-copy'></i>&nbsp;复制&nbsp;";
    }

    /**
     * 设置确认弹窗信息，如果返回空值，则不会弹出弹窗
     *
     * 允许返回字符串或数组类型
     *
     * @return array|string|void
     */
    public function confirm()
    {
        return [
            // 确认弹窗 title
            '您确定要复制这行数据吗？',
            // 确认弹窗 content
            $this->row->id,
        ];
    }

    /**
     * 处理请求
     *
     *
     * @return \Dcat\Admin\Actions\Response
     */
    public function handle(Request $request)
    {
        // 获取当前行ID
        $id = $this->getKey();

        // 获取 parameters 方法传递的参数
        $model = $request->get('model');
        $except = $request->get('except');

        // 复制数据
        $qb = $model::find($id)->replicate($except);
        $qb->save();
        $newId = $qb->id;

        // 返回响应结果并刷新页面
        return $this->response()->alert(true)->success('复制成功。新ID：')->detail($newId)->refresh();
    }

    /**
     * 设置要POST到接口的数据
     *
     * @return array
     */
    public function parameters()
    {
        return [
            // 发送当前行 id 字段数据到接口
            'id' => $this->row->id,
            // 把模型类名传递到接口
            'model' => $this->model,
            // 不需要复制的字段
            'except' => $this->except,
        ];
    }
}
